/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.converter;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.Application;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.convert.FacesConverter;
import javax.inject.Inject;
import org.omnifaces.util.BeansLocal;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Reflection;

@ApplicationScoped
public class ConverterManager {
    @Inject
    private BeanManager manager;
    private Map<String, Bean<Converter>> convertersById = new HashMap<String, Bean<Converter>>();
    private Map<Class<?>, Bean<Converter>> convertersByForClass = new HashMap();
    private TimeZone dateTimeConverterDefaultTimeZone;

    @PostConstruct
    public void init() {
        this.dateTimeConverterDefaultTimeZone = Boolean.parseBoolean(Faces.getInitParameter("javax.faces.DATETIMECONVERTER_DEFAULT_TIMEZONE_IS_SYSTEM_TIMEZONE")) ? TimeZone.getDefault() : null;
    }

    public Converter createConverter(Application application, String converterId) {
        Converter converter = application.createConverter(converterId);
        Bean<Converter> bean = this.convertersById.get(converterId);
        if (bean == null && !this.convertersById.containsKey(converterId)) {
            if (this.isUnmanaged(converter)) {
                bean = this.resolve(converter.getClass(), converterId, Object.class);
            }
            this.convertersById.put(converterId, bean);
        }
        if (bean != null && (converter = BeansLocal.getReference(this.manager, bean)) != null) {
            this.setDefaultPropertiesIfNecessary(converter);
        }
        return converter;
    }

    public Converter createConverter(Application application, Class<?> converterForClass) {
        Converter converter = application.createConverter(converterForClass);
        Bean<Converter> bean = this.convertersByForClass.get(converterForClass);
        if (bean == null && !this.convertersByForClass.containsKey(converterForClass)) {
            Class<?> converterClass;
            if (this.isUnmanaged(converter) && Reflection.findConstructor(converterClass = converter.getClass(), new Class[0]) != null && Reflection.findConstructor(converterClass, Class.class) == null) {
                bean = this.resolve(converterClass, "", converterForClass);
            }
            this.convertersByForClass.put(converterForClass, bean);
        }
        if (bean != null && (converter = BeansLocal.getReference(this.manager, bean)) != null) {
            this.setDefaultPropertiesIfNecessary(converter);
        }
        return converter;
    }

    private boolean isUnmanaged(Converter converter) {
        if (converter == null) {
            return false;
        }
        FacesConverter annotation = converter.getClass().getAnnotation(FacesConverter.class);
        if (annotation == null) {
            return false;
        }
        return !annotation.managed();
    }

    private Bean<Converter> resolve(Class<? extends Converter> converterClass, final String converterId, final Class<?> converterForClass) {
        Bean<? extends Converter> bean = BeansLocal.resolveExact(this.manager, converterClass, new Annotation[0]);
        if (bean == null) {
            FacesConverter annotation = converterClass.getAnnotation(FacesConverter.class);
            if (annotation != null) {
                bean = BeansLocal.resolveExact(this.manager, converterClass, new Annotation[]{annotation});
            }
            if (bean == null) {
                bean = BeansLocal.resolveExact(this.manager, converterClass, new Annotation[]{new FacesConverter(){

                    public Class<? extends Annotation> annotationType() {
                        return FacesConverter.class;
                    }

                    public String value() {
                        return converterId;
                    }

                    public boolean managed() {
                        return false;
                    }

                    public Class forClass() {
                        return converterForClass;
                    }
                }});
            }
        }
        return bean;
    }

    private void setDefaultPropertiesIfNecessary(Converter converter) {
        if (converter instanceof DateTimeConverter && this.dateTimeConverterDefaultTimeZone != null) {
            ((DateTimeConverter)converter).setTimeZone(this.dateTimeConverterDefaultTimeZone);
        }
    }
}

