/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.CombinedResource;
import org.eclipse.jetty.util.resource.MemoryResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactoryInternals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ResourceFactory {
    public static final Logger LOG = LoggerFactory.getLogger(ResourceFactory.class);

    public static Resource combine(List<Resource> resources) {
        return CombinedResource.combine(resources);
    }

    public static Resource combine(Resource ... resources) {
        return CombinedResource.combine(List.of(resources));
    }

    public Resource newResource(URI var1);

    @Deprecated(since="12.0.2", forRemoval=true)
    default public Resource newSystemResource(String resource) {
        return this.newClassLoaderResource(resource);
    }

    default public Resource newClassLoaderResource(String resource, boolean searchSystemClassLoader) {
        if (StringUtil.isBlank(resource)) {
            throw new IllegalArgumentException("Resource String is invalid: " + resource);
        }
        URL url = null;
        ArrayList<Function<String, URL>> loaders = new ArrayList<Function<String, URL>>();
        loaders.add(Thread.currentThread().getContextClassLoader()::getResource);
        loaders.add(ResourceFactory.class.getClassLoader()::getResource);
        if (searchSystemClassLoader) {
            loaders.add(ClassLoader::getSystemResource);
        }
        for (Function function : loaders) {
            if (url != null) break;
            try {
                url = (URL)function.apply(resource);
                if (url != null || !resource.startsWith("/")) continue;
                url = (URL)function.apply(resource.substring(1));
            }
            catch (IllegalArgumentException e2) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Ignoring bad getResource(): {}", (Object)resource, (Object)e2);
            }
        }
        if (url == null) {
            return null;
        }
        try {
            URI uri = url.toURI();
            return this.newResource(uri);
        }
        catch (URISyntaxException e3) {
            throw new IllegalArgumentException("Error creating resource from URL: " + String.valueOf(url), e3);
        }
    }

    default public Resource newClassLoaderResource(String resource) {
        return this.newClassLoaderResource(resource, true);
    }

    @Deprecated(since="12.0.2", forRemoval=true)
    default public Resource newClassPathResource(String resource) {
        return this.newClassLoaderResource(resource, false);
    }

    default public Resource newMemoryResource(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        return new MemoryResource(url);
    }

    default public Resource newResource(String resource) {
        if (StringUtil.isBlank(resource)) {
            throw new IllegalArgumentException("Resource String is invalid: " + resource);
        }
        return this.newResource(URIUtil.toURI(resource));
    }

    default public Resource newResource(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        return this.newResource(path.toUri());
    }

    default public Resource newResource(List<URI> uris) {
        if (uris == null || uris.isEmpty()) {
            throw new IllegalArgumentException("List of URIs is invalid");
        }
        return ResourceFactory.combine(uris.stream().map(this::newResource).toList());
    }

    default public Resource newResource(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        try {
            return this.newResource(url.toURI());
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException("Error creating resource from URL: " + String.valueOf(url), e2);
        }
    }

    default public Resource newJarFileResource(URI uri) {
        if (!uri.getScheme().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("Not an allowed path: " + String.valueOf(uri));
        }
        return this.newResource(URIUtil.toJarFileUri(uri));
    }

    public static boolean isSupported(String str2) {
        return ResourceFactoryInternals.isSupported(str2);
    }

    public static boolean isSupported(URI uri) {
        return ResourceFactoryInternals.isSupported(uri);
    }

    public static void registerResourceFactory(String scheme, ResourceFactory resourceFactory) {
        if (StringUtil.isBlank(scheme)) {
            throw new IllegalArgumentException("Scheme is blank");
        }
        ResourceFactoryInternals.RESOURCE_FACTORIES.put(scheme, resourceFactory);
    }

    public static ResourceFactory unregisterResourceFactory(String scheme) {
        if (StringUtil.isBlank(scheme)) {
            throw new IllegalArgumentException("Scheme is blank");
        }
        return ResourceFactoryInternals.RESOURCE_FACTORIES.remove(scheme);
    }

    public static ResourceFactory root() {
        return ResourceFactoryInternals.ROOT;
    }

    public static Closeable closeable() {
        return new ResourceFactoryInternals.Closeable();
    }

    public static LifeCycle lifecycle() {
        ResourceFactoryInternals.LifeCycle factory = new ResourceFactoryInternals.LifeCycle();
        org.eclipse.jetty.util.component.LifeCycle.start(factory);
        return factory;
    }

    public static ResourceFactory of(final Resource baseResource) {
        Objects.requireNonNull(baseResource);
        if (baseResource instanceof ResourceFactory) {
            ResourceFactory resourceFactory = (ResourceFactory)((Object)baseResource);
            return resourceFactory;
        }
        return new ResourceFactory(){

            @Override
            public Resource newResource(URI resource) {
                return this.newResource(resource.toString());
            }

            @Override
            public Resource newResource(String resource) {
                return baseResource.resolve(resource);
            }
        };
    }

    public static ResourceFactory of(final Container container2) {
        Objects.requireNonNull(container2);
        LifeCycle factory = container2.getBean(LifeCycle.class);
        if (factory == null) {
            factory = ResourceFactory.lifecycle();
            container2.addBean(factory, true);
            final LifeCycle finalFactory = factory;
            container2.addEventListener(new LifeCycle.Listener(){

                @Override
                public void lifeCycleStopped(org.eclipse.jetty.util.component.LifeCycle event) {
                    container2.removeBean(this);
                    container2.removeBean(finalFactory);
                }
            });
        }
        return factory;
    }

    public static interface LifeCycle
    extends org.eclipse.jetty.util.component.LifeCycle,
    ResourceFactory,
    Dumpable {
    }

    public static interface Closeable
    extends ResourceFactory,
    java.io.Closeable {
        @Override
        public void close();
    }
}

