/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jetty.server.AllowedResourceAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymlinkAllowedResourceAliasChecker
extends AllowedResourceAliasChecker {
    private static final Logger LOG = LoggerFactory.getLogger(SymlinkAllowedResourceAliasChecker.class);

    public SymlinkAllowedResourceAliasChecker(ContextHandler contextHandler) {
        super(contextHandler);
    }

    public SymlinkAllowedResourceAliasChecker(ContextHandler contextHandler, Resource baseResource) {
        super(contextHandler, baseResource);
    }

    @Override
    protected boolean check(String pathInContext, Path path) {
        if (this._baseResource == null) {
            return false;
        }
        if (File.separatorChar != '/' && pathInContext.indexOf(File.separatorChar) >= 0) {
            return false;
        }
        String[] segments = pathInContext.substring(1).split("/");
        StringBuilder segmentPath = new StringBuilder();
        try {
            for (String segment : segments) {
                segmentPath.append("/").append(segment);
                Resource fromBase = this._baseResource.resolve(segmentPath.toString());
                for (Resource r : fromBase) {
                    Path p = r.getPath();
                    if (Files.isSymbolicLink(p)) {
                        return !this.getContextHandler().isProtectedTarget(segmentPath.toString());
                    }
                    if (this.isAllowed(p)) continue;
                    return false;
                }
            }
        }
        catch (Throwable t2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to check alias", t2);
            }
            return false;
        }
        return false;
    }
}

