/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.content;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMappingHttpContentFactory
implements HttpContent.Factory {
    private static final Logger LOG = LoggerFactory.getLogger(FileMappingHttpContentFactory.class);
    private static final int DEFAULT_MIN_FILE_SIZE = 16384;
    private final HttpContent.Factory _factory;
    private final int _minFileSize;

    public FileMappingHttpContentFactory(HttpContent.Factory factory) {
        this(factory, 16384);
    }

    public FileMappingHttpContentFactory(HttpContent.Factory factory, int minFileSize) {
        this._factory = Objects.requireNonNull(factory);
        this._minFileSize = minFileSize;
    }

    @Override
    public HttpContent getContent(String path) throws IOException {
        long contentLength;
        HttpContent content = this._factory.getContent(path);
        if (content != null && (contentLength = content.getContentLengthValue()) > (long)this._minFileSize && contentLength < Integer.MAX_VALUE) {
            return new FileMappedHttpContent(content);
        }
        return content;
    }

    private static class FileMappedHttpContent
    extends HttpContent.Wrapper {
        private static final ByteBuffer SENTINEL_BUFFER = BufferUtil.allocate(0);
        private final AutoLock _lock = new AutoLock();
        private final HttpContent _content;
        private volatile ByteBuffer _buffer;

        public FileMappedHttpContent(HttpContent content) {
            super(content);
            this._content = content;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            ByteBuffer buffer = this._buffer;
            if (buffer != null) {
                return buffer == SENTINEL_BUFFER ? super.getByteBuffer() : buffer.asReadOnlyBuffer();
            }
            try (AutoLock lock = this._lock.lock();){
                if (this._buffer == null) {
                    this._buffer = this.getMappedByteBuffer();
                }
                ByteBuffer byteBuffer = this._buffer == SENTINEL_BUFFER ? super.getByteBuffer() : this._buffer.asReadOnlyBuffer();
                return byteBuffer;
            }
        }

        @Override
        public long getBytesOccupied() {
            ByteBuffer buffer = this._buffer;
            if (buffer != null) {
                return buffer == SENTINEL_BUFFER ? super.getBytesOccupied() : 0L;
            }
            try (AutoLock lock = this._lock.lock();){
                if (this._buffer == null) {
                    this._buffer = this.getMappedByteBuffer();
                }
                long l = this._buffer == SENTINEL_BUFFER ? super.getBytesOccupied() : 0L;
                return l;
            }
        }

        private ByteBuffer getMappedByteBuffer() {
            try {
                ByteBuffer byteBuffer = BufferUtil.toMappedBuffer(this._content.getResource().getPath());
                return byteBuffer == null ? SENTINEL_BUFFER : byteBuffer;
            }
            catch (Throwable t2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error getting Mapped Buffer", t2);
                }
                return SENTINEL_BUFFER;
            }
        }
    }
}

