/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.webapp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.MountedPathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebInfConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(WebInfConfiguration.class);
    public static final String TEMPDIR_CONFIGURED = "org.eclipse.jetty.tmpdirConfigured";
    public static final String TEMPORARY_RESOURCE_BASE = "org.eclipse.jetty.webapp.tmpResourceBase";
    public static final String ORIGINAL_RESOURCE_BASE = "org.eclipse.jetty.webapp.originalResourceBase";

    public WebInfConfiguration() {
        this(new AbstractConfiguration.Builder());
    }

    protected WebInfConfiguration(AbstractConfiguration.Builder builder) {
        super(builder);
    }

    @Override
    public void preConfigure(WebAppContext context2) throws Exception {
        this.resolveTempDirectory(context2);
        context2.createTempDirectory();
        this.unpack(context2);
    }

    @Override
    public void configure(WebAppContext context2) throws Exception {
        Resource webInf = context2.getWebInf();
        if (webInf != null && webInf.isDirectory() && context2.getClassLoader() instanceof WebAppClassLoader) {
            Resource lib;
            Resource classes = webInf.resolve("classes/");
            if (Resources.isReadableDirectory(classes)) {
                ((WebAppClassLoader)context2.getClassLoader()).addClassPath(classes);
            }
            if (Resources.isReadableDirectory(lib = webInf.resolve("lib/"))) {
                ((WebAppClassLoader)context2.getClassLoader()).addJars(lib);
            }
        }
    }

    @Override
    public void deconfigure(WebAppContext context2) throws Exception {
        Boolean tmpdirConfigured = (Boolean)context2.getAttribute(TEMPDIR_CONFIGURED);
        if (tmpdirConfigured != null && !tmpdirConfigured.booleanValue()) {
            context2.setTempDirectory(null);
        }
        Resource originalBaseResource = (Resource)context2.removeAttribute(ORIGINAL_RESOURCE_BASE);
        context2.setBaseResource(originalBaseResource);
    }

    public void resolveTempDirectory(WebAppContext context2) throws Exception {
        File tempDirectory = context2.getTempDirectory();
        if (tempDirectory != null) {
            context2.setAttribute(TEMPDIR_CONFIGURED, Boolean.TRUE);
            return;
        }
        File servletTmpDir = IO.asFile(context2.getAttribute("jakarta.servlet.context.tempdir"));
        if (servletTmpDir != null) {
            tempDirectory = servletTmpDir;
            context2.setTempDirectory(tempDirectory);
            return;
        }
        this.makeTempDirectory(context2.getServer().getContext().getTempDirectory(), context2);
    }

    public void makeTempDirectory(File parent, WebAppContext context2) throws Exception {
        File tmpDir;
        if (!(parent != null && parent.exists() && parent.canWrite() && parent.isDirectory())) {
            throw new IllegalStateException("Parent for temp dir not configured correctly: " + (String)(parent == null ? "null" : "writeable=" + parent.canWrite()));
        }
        boolean persistent = context2.isTempDirectoryPersistent() || "work".equals(parent.toPath().getFileName().toString());
        String temp = WebInfConfiguration.getCanonicalNameForWebAppTmpDir(context2);
        if (persistent) {
            tmpDir = new File(parent, temp);
        } else {
            tmpDir = Files.createTempDirectory(parent.toPath(), temp, new FileAttribute[0]).toFile();
            tmpDir.deleteOnExit();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set temp dir {}", (Object)tmpDir);
        }
        context2.setTempDirectory(tmpDir);
        context2.setTempDirectoryPersistent(persistent);
    }

    public void unpack(WebAppContext context2) throws IOException {
        Resource webApp = context2.getBaseResource();
        context2.setAttribute(ORIGINAL_RESOURCE_BASE, context2.getBaseResource());
        if (webApp == null) {
            Resource jarWebApp;
            String war = context2.getWar();
            webApp = war != null && war.length() > 0 ? context2.newResource(war) : context2.getBaseResource();
            if (webApp == null) {
                throw new IllegalStateException("No resourceBase or war set for context");
            }
            if (webApp.isAlias()) {
                Resource realWebApp;
                URI realURI = webApp.getRealURI();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} anti-aliased to {}", (Object)webApp, (Object)realURI);
                }
                if (Resources.exists(realWebApp = context2.newResource(realURI))) {
                    webApp = realWebApp;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try webapp={} exists={} directory={} file={}", webApp, webApp.exists(), webApp.isDirectory(), webApp.getPath());
            }
            Resource originalWarResource = webApp;
            if (Resources.isReadableFile(webApp) && FileID.isJavaArchive(webApp.getURI()) && !webApp.getURI().getScheme().equalsIgnoreCase("jar") && Resources.isReadableFile(jarWebApp = context2.getResourceFactory().newJarFileResource(webApp.getURI()))) {
                webApp = jarWebApp;
            }
            if (context2.isCopyWebDir() && webApp.getPath() != null && originalWarResource.isDirectory() || context2.isExtractWAR() && webApp.getPath() != null && !originalWarResource.isDirectory() || context2.isExtractWAR() && webApp.getPath() == null || !originalWarResource.isDirectory()) {
                Path sibling;
                Path warPath;
                Path extractedWebAppDir = null;
                if (war != null && FileID.isWebArchive(warPath = Path.of(URIUtil.toURI(war))) && Files.exists(warPath, new LinkOption[0]) && Files.exists(sibling = warPath.getParent().resolve(FileID.getBasename(warPath)), new LinkOption[0]) && Files.isDirectory(sibling, new LinkOption[0]) && Files.isWritable(sibling)) {
                    extractedWebAppDir = sibling;
                }
                if (extractedWebAppDir == null) {
                    extractedWebAppDir = context2.getTempDirectory().toPath().resolve("webapp");
                    context2.setAttribute(TEMPORARY_RESOURCE_BASE, extractedWebAppDir);
                }
                if (Resources.isReadableDirectory(webApp)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Copy {} to  {}", (Object)webApp, (Object)extractedWebAppDir);
                    }
                    webApp.copyTo(extractedWebAppDir);
                } else {
                    File extractionLock = new File(context2.getTempDirectory(), ".extract_lock");
                    if (!Files.exists(extractedWebAppDir, new LinkOption[0])) {
                        extractionLock.createNewFile();
                        Files.createDirectory(extractedWebAppDir, new FileAttribute[0]);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Extract {} to {}", (Object)webApp, (Object)extractedWebAppDir);
                        }
                        resourceFactory = ResourceFactory.closeable();
                        try {
                            jarWebApp = resourceFactory.newJarFileResource(webApp.getURI());
                            jarWebApp.copyTo(extractedWebAppDir);
                        }
                        finally {
                            if (resourceFactory != null) {
                                resourceFactory.close();
                            }
                        }
                        extractionLock.delete();
                    } else if (originalWarResource.lastModified().isAfter(Files.getLastModifiedTime(extractedWebAppDir, new LinkOption[0]).toInstant()) || extractionLock.exists()) {
                        extractionLock.createNewFile();
                        if (IO.delete(extractedWebAppDir)) {
                            Files.createDirectory(extractedWebAppDir, new FileAttribute[0]);
                        } else if (LOG.isInfoEnabled()) {
                            LOG.info("Unable to delete path {}, reusing existing path", (Object)extractedWebAppDir);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Extract {} to {}", (Object)webApp, (Object)extractedWebAppDir);
                        }
                        resourceFactory = ResourceFactory.closeable();
                        try {
                            jarWebApp = resourceFactory.newJarFileResource(webApp.getURI());
                            jarWebApp.copyTo(extractedWebAppDir);
                        }
                        finally {
                            if (resourceFactory != null) {
                                resourceFactory.close();
                            }
                        }
                        extractionLock.delete();
                    }
                }
                Resource extractedWebApp = context2.getResourceFactory().newResource(extractedWebAppDir.normalize());
                if (extractedWebApp == null) {
                    LOG.warn("Unable to use non-existent extracted war location: " + String.valueOf(extractedWebApp));
                } else {
                    webApp = extractedWebApp;
                }
            }
            if (Resources.missing(webApp)) {
                LOG.warn("Web application not found {}", (Object)war);
                throw new FileNotFoundException(war);
            }
            context2.setBaseResource(webApp);
            if (LOG.isDebugEnabled()) {
                LOG.debug("webapp={}", (Object)webApp);
            }
        }
        if (context2.isCopyWebInf() && !context2.isCopyWebDir()) {
            Resource webInf = webApp.resolve("WEB-INF/");
            if (Resources.isReadableDirectory(webInf)) {
                Resource webInfClasses;
                File extractedWebInfDir = new File(context2.getTempDirectory(), "webinf");
                if (extractedWebInfDir.exists()) {
                    IO.delete(extractedWebInfDir);
                }
                extractedWebInfDir.mkdir();
                Resource webInfLib = webInf.resolve("lib/");
                File webInfDir = new File(extractedWebInfDir, "WEB-INF");
                webInfDir.mkdir();
                if (Resources.isReadableDirectory(webInfLib)) {
                    File webInfLibDir = new File(webInfDir, "lib");
                    if (webInfLibDir.exists()) {
                        IO.delete(webInfLibDir);
                    }
                    webInfLibDir.mkdir();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Copying WEB-INF/lib {} to {}", (Object)webInfLib, (Object)webInfLibDir);
                    }
                    webInfLib.copyTo(webInfLibDir.toPath());
                }
                if (Resources.isReadableDirectory(webInfClasses = webInf.resolve("classes/"))) {
                    File webInfClassesDir = new File(webInfDir, "classes");
                    if (webInfClassesDir.exists()) {
                        IO.delete(webInfClassesDir);
                    }
                    webInfClassesDir.mkdir();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Copying WEB-INF/classes from {} to {}", (Object)webInfClasses, (Object)webInfClassesDir.getAbsolutePath());
                    }
                    webInfClasses.copyTo(webInfClassesDir.toPath());
                }
                webInf = context2.getResourceFactory().newResource(extractedWebInfDir.getCanonicalPath());
            }
            Resource rc = ResourceFactory.combine(webInf, webApp);
            if (LOG.isDebugEnabled()) {
                LOG.debug("context.baseResource={}", (Object)rc);
            }
            context2.setBaseResource(rc);
        }
    }

    public static String getCanonicalNameForWebAppTmpDir(WebAppContext context2) {
        Connector[] connectors;
        StringBuilder canonicalName = new StringBuilder();
        canonicalName.append("jetty-");
        Server server = context2.getServer();
        if (server != null && (connectors = server.getConnectors()).length > 0) {
            String host = null;
            int port = 0;
            Connector connector = connectors[0];
            if (connector instanceof NetworkConnector) {
                NetworkConnector connector2 = (NetworkConnector)connector;
                host = connector2.getHost();
                port = connector2.getLocalPort();
                if (port < 0) {
                    port = connector2.getPort();
                }
            }
            if (host == null) {
                host = "0.0.0.0";
            }
            canonicalName.append(host);
            canonicalName.append("-");
            canonicalName.append(port);
            canonicalName.append("-");
        }
        try {
            Resource resource = context2.getBaseResource();
            if (resource == null) {
                if (context2.getWar() == null || context2.getWar().length() == 0) {
                    throw new IllegalStateException("No resourceBase or war set for context");
                }
                resource = context2.newResource(context2.getWar());
            }
            String resourceBaseName = WebInfConfiguration.getResourceBaseName(resource);
            canonicalName.append(resourceBaseName);
            canonicalName.append("-");
        }
        catch (Exception e2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Can't get resource base name", e2);
            }
            canonicalName.append("-");
        }
        String contextPath = context2.getContextPath();
        contextPath = contextPath.replace('/', '_');
        contextPath = contextPath.replace('\\', '_');
        canonicalName.append(contextPath);
        canonicalName.append("-");
        List<String> vhosts = context2.getVirtualHosts();
        if (vhosts == null || vhosts.size() <= 0) {
            canonicalName.append("any");
        } else {
            canonicalName.append(vhosts.get(0));
        }
        for (int i = 0; i < canonicalName.length(); ++i) {
            char c = canonicalName.charAt(i);
            if (Character.isJavaIdentifierPart(c) || "-.".indexOf(c) >= 0) continue;
            canonicalName.setCharAt(i, '.');
        }
        canonicalName.append("-");
        return StringUtil.sanitizeFileSystemName(canonicalName.toString());
    }

    protected static String getResourceBaseName(Resource resource) {
        Path resourceFile = resource.getPath();
        if (resourceFile != null && resource instanceof MountedPathResource) {
            resourceFile = ((MountedPathResource)resource).getContainerPath();
        }
        if (resourceFile != null) {
            Path fileName = resourceFile.getFileName();
            return fileName == null ? "" : fileName.toString();
        }
        URI uri = resource.getURI();
        if (uri == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource has no URI reference: {}", (Object)resource);
            }
            return "";
        }
        return URIUtil.getUriLastPathSegment(uri);
    }
}

