/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.PermissionResolver;
import org.apache.shiro.lang.util.StringUtils;

public final class PermissionUtils {
    private PermissionUtils() {
    }

    public static Set<Permission> resolveDelimitedPermissions(String s2, PermissionResolver permissionResolver) {
        Set<String> permStrings = PermissionUtils.toPermissionStrings(s2);
        return PermissionUtils.resolvePermissions(permStrings, permissionResolver);
    }

    public static Set<String> toPermissionStrings(String permissionsString) {
        String[] tokens2 = StringUtils.split(permissionsString);
        if (tokens2 != null && tokens2.length > 0) {
            return new LinkedHashSet<String>(Arrays.asList(tokens2));
        }
        return null;
    }

    public static Set<Permission> resolvePermissions(Collection<String> permissionStrings, PermissionResolver permissionResolver) {
        LinkedHashSet<Permission> permissions = new LinkedHashSet<Permission>(permissionStrings.size());
        for (String permissionString : permissionStrings) {
            permissions.add(permissionResolver.resolvePermission(permissionString));
        }
        return permissions;
    }
}

