/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt;

import java.util.Collection;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.lang.util.Destroyable;
import org.apache.shiro.lang.util.LifecycleUtils;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.AbstractNativeSessionManager;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.ExecutorServiceSessionValidationScheduler;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionValidationScheduler;
import org.apache.shiro.session.mgt.ValidatingSession;
import org.apache.shiro.session.mgt.ValidatingSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValidatingSessionManager
extends AbstractNativeSessionManager
implements ValidatingSessionManager,
Destroyable {
    public static final long DEFAULT_SESSION_VALIDATION_INTERVAL = 3600000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractValidatingSessionManager.class);
    protected boolean sessionValidationSchedulerEnabled = true;
    protected SessionValidationScheduler sessionValidationScheduler;
    protected long sessionValidationInterval = 3600000L;

    public boolean isSessionValidationSchedulerEnabled() {
        return this.sessionValidationSchedulerEnabled;
    }

    public void setSessionValidationSchedulerEnabled(boolean sessionValidationSchedulerEnabled) {
        this.sessionValidationSchedulerEnabled = sessionValidationSchedulerEnabled;
    }

    public void setSessionValidationScheduler(SessionValidationScheduler sessionValidationScheduler) {
        this.sessionValidationScheduler = sessionValidationScheduler;
    }

    public SessionValidationScheduler getSessionValidationScheduler() {
        return this.sessionValidationScheduler;
    }

    private void enableSessionValidationIfNecessary() {
        SessionValidationScheduler scheduler = this.getSessionValidationScheduler();
        if (this.isSessionValidationSchedulerEnabled() && (scheduler == null || !scheduler.isEnabled())) {
            this.enableSessionValidation();
        }
    }

    public void setSessionValidationInterval(long sessionValidationInterval) {
        this.sessionValidationInterval = sessionValidationInterval;
    }

    public long getSessionValidationInterval() {
        return this.sessionValidationInterval;
    }

    @Override
    protected final Session doGetSession(SessionKey key) throws InvalidSessionException {
        this.enableSessionValidationIfNecessary();
        LOGGER.trace("Attempting to retrieve session with key {}", (Object)key);
        Session s2 = this.retrieveSession(key);
        if (s2 != null) {
            this.validate(s2, key);
        }
        return s2;
    }

    protected abstract Session retrieveSession(SessionKey var1) throws UnknownSessionException;

    @Override
    protected Session createSession(SessionContext context2) throws AuthorizationException {
        this.enableSessionValidationIfNecessary();
        return this.doCreateSession(context2);
    }

    protected abstract Session doCreateSession(SessionContext var1) throws AuthorizationException;

    protected void validate(Session session, SessionKey key) throws InvalidSessionException {
        try {
            this.doValidate(session);
        }
        catch (ExpiredSessionException ese) {
            this.onExpiration(session, ese, key);
            throw ese;
        }
        catch (InvalidSessionException ise) {
            this.onInvalidation(session, ise, key);
            throw ise;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onExpiration(Session s2, ExpiredSessionException ese, SessionKey key) {
        LOGGER.trace("Session with id [{}] has expired.", (Object)s2.getId());
        try {
            this.onExpiration(s2);
            this.notifyExpiration(s2);
        }
        finally {
            this.afterExpired(s2);
        }
    }

    protected void onExpiration(Session session) {
        this.onChange(session);
    }

    protected void afterExpired(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onInvalidation(Session s2, InvalidSessionException ise, SessionKey key) {
        if (ise instanceof ExpiredSessionException) {
            this.onExpiration(s2, (ExpiredSessionException)ise, key);
            return;
        }
        LOGGER.trace("Session with id [{}] is invalid.", (Object)s2.getId());
        try {
            this.onStop(s2);
            this.notifyStop(s2);
        }
        finally {
            this.afterStopped(s2);
        }
    }

    protected void doValidate(Session session) throws InvalidSessionException {
        if (!(session instanceof ValidatingSession)) {
            String msg = "The " + this.getClass().getName() + " implementation only supports validating Session implementations of the " + ValidatingSession.class.getName() + " interface.  Please either implement this interface in your session implementation or override the " + AbstractValidatingSessionManager.class.getName() + ".doValidate(Session) method to perform validation.";
            throw new IllegalStateException(msg);
        }
        ((ValidatingSession)session).validate();
    }

    protected long getTimeout(Session session) {
        return session.getTimeout();
    }

    protected SessionValidationScheduler createSessionValidationScheduler() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No sessionValidationScheduler set.  Attempting to create default instance.");
        }
        ExecutorServiceSessionValidationScheduler scheduler = new ExecutorServiceSessionValidationScheduler(this);
        scheduler.setSessionValidationInterval(this.getSessionValidationInterval());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Created default SessionValidationScheduler instance of type [" + scheduler.getClass().getName() + "].");
        }
        return scheduler;
    }

    protected synchronized void enableSessionValidation() {
        SessionValidationScheduler scheduler = this.getSessionValidationScheduler();
        if (scheduler == null) {
            scheduler = this.createSessionValidationScheduler();
            this.setSessionValidationScheduler(scheduler);
        }
        if (!scheduler.isEnabled()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Enabling session validation scheduler...");
            }
            scheduler.enableSessionValidation();
            this.afterSessionValidationEnabled();
        }
    }

    protected void afterSessionValidationEnabled() {
    }

    protected synchronized void disableSessionValidation() {
        this.beforeSessionValidationDisabled();
        SessionValidationScheduler scheduler = this.getSessionValidationScheduler();
        if (scheduler != null) {
            block4: {
                try {
                    scheduler.disableSessionValidation();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Disabled session validation scheduler.");
                    }
                }
                catch (Exception e2) {
                    if (!LOGGER.isDebugEnabled()) break block4;
                    String msg = "Unable to disable SessionValidationScheduler.  Ignoring (shutting down)...";
                    LOGGER.debug(msg, e2);
                }
            }
            LifecycleUtils.destroy(scheduler);
            this.setSessionValidationScheduler(null);
        }
    }

    protected void beforeSessionValidationDisabled() {
    }

    @Override
    public void destroy() {
        this.disableSessionValidation();
    }

    @Override
    public void validateSessions() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Validating all active sessions...");
        }
        int invalidCount = 0;
        Collection<Session> activeSessions = this.getActiveSessions();
        if (activeSessions != null && !activeSessions.isEmpty()) {
            for (Session s2 : activeSessions) {
                try {
                    DefaultSessionKey key = new DefaultSessionKey(s2.getId());
                    this.validate(s2, key);
                }
                catch (InvalidSessionException e2) {
                    if (LOGGER.isDebugEnabled()) {
                        boolean expired = e2 instanceof ExpiredSessionException;
                        String msg = "Invalidated session with id [" + String.valueOf(s2.getId()) + "]" + (expired ? " (expired)" : " (stopped)");
                        LOGGER.debug(msg);
                    }
                    ++invalidCount;
                }
            }
        }
        if (LOGGER.isInfoEnabled()) {
            Object msg = "Finished session validation.";
            msg = invalidCount > 0 ? (String)msg + "  [" + invalidCount + "] sessions were stopped." : (String)msg + "  No sessions were stopped.";
            LOGGER.info((String)msg);
        }
    }

    protected abstract Collection<Session> getActiveSessions();
}

