/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.filters;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.ee.filters.AuthenticationFilterDelegate;
import org.apache.shiro.ee.filters.FormResubmitSupport;
import org.apache.shiro.ee.filters.Forms;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;

public class LogoutFilter
extends org.apache.shiro.web.filter.authc.LogoutFilter {
    static final Forms.FallbackPredicate YES_PREDICATE = LogoutFilter.createPredicate();
    static final String LOGOUT_PREDICATE_ATTR_NAME = "org.apache.shiro.ee.logout-predicate";
    private final AuthenticationFilterDelegate delegate = new AuthenticationFilterDelegate(new Methods());

    @Override
    protected void issueRedirect(ServletRequest request, ServletResponse response, String redirectUrl) throws Exception {
        if (request instanceof HttpServletRequest) {
            Forms.FallbackPredicate logoutFallbackType = (Forms.FallbackPredicate)request.getAttribute(LOGOUT_PREDICATE_ATTR_NAME);
            Forms.logout(WebUtils.toHttp(request), WebUtils.toHttp(response), logoutFallbackType, redirectUrl);
        } else {
            super.issueRedirect(request, response, redirectUrl);
        }
    }

    static Forms.FallbackPredicate createPredicate() {
        return (path, request) -> {
            String referer = FormResubmitSupport.getReferer(request);
            return !path.equals(referer);
        };
    }

    @Override
    public boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        return this.delegate.preHandle(request, response);
    }

    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        return this.delegate.isAccessAllowed(request, response, mappedValue);
    }

    public void redirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        this.delegate.redirectToLogin(request, response);
    }

    public boolean isLoginRequest(ServletRequest request, ServletResponse response) {
        return this.delegate.isLoginRequest(request, response);
    }

    public boolean onLoginFailure(AuthenticationToken token, AuthenticationException e2, ServletRequest request, ServletResponse response) {
        return this.delegate.onLoginFailure(token, e2, request, response);
    }

    public void saveRequestAndRedirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        this.delegate.saveRequestAndRedirectToLogin(request, response);
    }

    public void saveRequest(ServletRequest request) {
        this.delegate.saveRequest(request);
    }

    public boolean isUseRemembered() {
        return this.delegate.isUseRemembered();
    }

    public void setUseRemembered(boolean useRemembered) {
        this.delegate.setUseRemembered(useRemembered);
    }

    public int getLoginFailedWaitTime() {
        return this.delegate.getLoginFailedWaitTime();
    }

    public void setLoginFailedWaitTime(int loginFailedWaitTime) {
        this.delegate.setLoginFailedWaitTime(loginFailedWaitTime);
    }

    public Forms.FallbackPredicate getLoginFallbackType() {
        return this.delegate.getLoginFallbackType();
    }

    public void setLoginFallbackType(Forms.FallbackPredicate loginFallbackType) {
        this.delegate.setLoginFallbackType(loginFallbackType);
    }

    public Forms.FallbackPredicate getLogoutFallbackType() {
        return this.delegate.getLogoutFallbackType();
    }

    public void setLogoutFallbackType(Forms.FallbackPredicate logoutFallbackType) {
        this.delegate.setLogoutFallbackType(logoutFallbackType);
    }

    private final class Methods
    implements AuthenticationFilterDelegate.MethodsFromFilter {
        private Methods() {
        }

        @Override
        public Subject getSubject(ServletRequest request, ServletResponse response) {
            return LogoutFilter.super.getSubject(request, response);
        }

        @Override
        public boolean isLoginRequest(ServletRequest request, ServletResponse response) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLoginUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
            return LogoutFilter.super.preHandle(request, response);
        }

        @Override
        public boolean onLoginFailure(AuthenticationToken token, AuthenticationException e2, ServletRequest request, ServletResponse response) {
            throw new UnsupportedOperationException();
        }
    }
}

