/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Rescorer;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;

public abstract class QueryRescorer
extends Rescorer {
    private final Query query;

    public QueryRescorer(Query query2) {
        this.query = query2;
    }

    protected abstract float combine(float var1, boolean var2, float var3);

    @Override
    public TopDocs rescore(IndexSearcher searcher, TopDocs firstPassTopDocs, int topN) throws IOException {
        ScoreDoc[] hits = (ScoreDoc[])firstPassTopDocs.scoreDocs.clone();
        Arrays.sort(hits, new Comparator<ScoreDoc>(){

            @Override
            public int compare(ScoreDoc a, ScoreDoc b) {
                return a.doc - b.doc;
            }
        });
        List<LeafReaderContext> leaves = searcher.getIndexReader().leaves();
        Query rewritten = searcher.rewrite(this.query);
        Weight weight = searcher.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
        int readerUpto = -1;
        int endDoc = 0;
        int docBase = 0;
        Scorer scorer = null;
        for (int hitUpto = 0; hitUpto < hits.length; ++hitUpto) {
            ScoreDoc hit = hits[hitUpto];
            int docID = hit.doc;
            LeafReaderContext readerContext = null;
            while (docID >= endDoc) {
                readerContext = leaves.get(++readerUpto);
                endDoc = readerContext.docBase + readerContext.reader().maxDoc();
            }
            if (readerContext != null) {
                docBase = readerContext.docBase;
                scorer = weight.scorer(readerContext);
            }
            if (scorer != null) {
                int targetDoc = docID - docBase;
                int actualDoc = scorer.docID();
                if (actualDoc < targetDoc) {
                    actualDoc = scorer.iterator().advance(targetDoc);
                }
                if (actualDoc == targetDoc) {
                    hit.score = this.combine(hit.score, true, scorer.score());
                    continue;
                }
                assert (actualDoc > targetDoc);
                hit.score = this.combine(hit.score, false, 0.0f);
                continue;
            }
            hit.score = this.combine(hit.score, false, 0.0f);
        }
        Comparator<ScoreDoc> sortDocComparator = new Comparator<ScoreDoc>(){

            @Override
            public int compare(ScoreDoc a, ScoreDoc b) {
                if (a.score > b.score) {
                    return -1;
                }
                if (a.score < b.score) {
                    return 1;
                }
                return a.doc - b.doc;
            }
        };
        if (topN < hits.length) {
            ArrayUtil.select(hits, 0, hits.length, topN, sortDocComparator);
            ScoreDoc[] subset = new ScoreDoc[topN];
            System.arraycopy(hits, 0, subset, 0, topN);
            hits = subset;
        }
        Arrays.sort(hits, sortDocComparator);
        return new TopDocs(firstPassTopDocs.totalHits, hits);
    }

    @Override
    public Explanation explain(IndexSearcher searcher, Explanation firstPassExplanation, int docID) throws IOException {
        Explanation secondPassExplanation = searcher.explain(this.query, docID);
        Number secondPassScore = secondPassExplanation.isMatch() ? (Number)secondPassExplanation.getValue() : (Number)null;
        float score = secondPassScore == null ? this.combine(firstPassExplanation.getValue().floatValue(), false, 0.0f) : this.combine(firstPassExplanation.getValue().floatValue(), true, secondPassScore.floatValue());
        Explanation first = Explanation.match(firstPassExplanation.getValue(), "first pass score", firstPassExplanation);
        Explanation second = secondPassScore == null ? Explanation.noMatch("no second pass score", new Explanation[0]) : Explanation.match(secondPassScore, "second pass score", secondPassExplanation);
        return Explanation.match((Number)Float.valueOf(score), "combined first and second pass score using " + this.getClass(), first, second);
    }

    public static TopDocs rescore(IndexSearcher searcher, TopDocs topDocs, Query query2, final double weight, int topN) throws IOException {
        return new QueryRescorer(query2){

            @Override
            protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                float score = firstPassScore;
                if (secondPassMatches) {
                    score = (float)((double)score + weight * (double)secondPassScore);
                }
                return score;
            }
        }.rescore(searcher, topDocs, topN);
    }
}

