/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apache.lucene.search.BlockMaxConjunctionScorer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.ConjunctionScorer;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DisjunctionSumScorer;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.ReqExclScorer;
import org.apache.lucene.search.ReqOptSumScorer;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.ScorerUtil;
import org.apache.lucene.search.WANDScorer;
import org.apache.lucene.search.Weight;

final class Boolean2ScorerSupplier
extends ScorerSupplier {
    private final Weight weight;
    private final Map<BooleanClause.Occur, Collection<ScorerSupplier>> subs;
    private final ScoreMode scoreMode;
    private final int minShouldMatch;
    private long cost = -1L;
    private boolean topLevelScoringClause;

    Boolean2ScorerSupplier(Weight weight, Map<BooleanClause.Occur, Collection<ScorerSupplier>> subs, ScoreMode scoreMode, int minShouldMatch) {
        if (minShouldMatch < 0) {
            throw new IllegalArgumentException("minShouldMatch must be positive, but got: " + minShouldMatch);
        }
        if (minShouldMatch != 0 && minShouldMatch >= subs.get((Object)BooleanClause.Occur.SHOULD).size()) {
            throw new IllegalArgumentException("minShouldMatch must be strictly less than the number of SHOULD clauses");
        }
        if (!scoreMode.needsScores() && minShouldMatch == 0 && subs.get((Object)BooleanClause.Occur.SHOULD).size() > 0 && subs.get((Object)BooleanClause.Occur.MUST).size() + subs.get((Object)BooleanClause.Occur.FILTER).size() > 0) {
            throw new IllegalArgumentException("Cannot pass purely optional clauses if scores are not needed");
        }
        if (subs.get((Object)BooleanClause.Occur.SHOULD).size() + subs.get((Object)BooleanClause.Occur.MUST).size() + subs.get((Object)BooleanClause.Occur.FILTER).size() == 0) {
            throw new IllegalArgumentException("There should be at least one positive clause");
        }
        this.weight = weight;
        this.subs = subs;
        this.scoreMode = scoreMode;
        this.minShouldMatch = minShouldMatch;
    }

    private long computeCost() {
        OptionalLong minRequiredCost = Stream.concat(this.subs.get((Object)BooleanClause.Occur.MUST).stream(), this.subs.get((Object)BooleanClause.Occur.FILTER).stream()).mapToLong(ScorerSupplier::cost).min();
        if (minRequiredCost.isPresent() && this.minShouldMatch == 0) {
            return minRequiredCost.getAsLong();
        }
        Collection<ScorerSupplier> optionalScorers = this.subs.get((Object)BooleanClause.Occur.SHOULD);
        long shouldCost = ScorerUtil.costWithMinShouldMatch(optionalScorers.stream().mapToLong(ScorerSupplier::cost), optionalScorers.size(), this.minShouldMatch);
        return Math.min(minRequiredCost.orElse(Long.MAX_VALUE), shouldCost);
    }

    @Override
    public void setTopLevelScoringClause() throws IOException {
        this.topLevelScoringClause = true;
        if (this.subs.get((Object)BooleanClause.Occur.SHOULD).size() + this.subs.get((Object)BooleanClause.Occur.MUST).size() == 1) {
            for (ScorerSupplier ss : this.subs.get((Object)BooleanClause.Occur.SHOULD)) {
                ss.setTopLevelScoringClause();
            }
            for (ScorerSupplier ss : this.subs.get((Object)BooleanClause.Occur.MUST)) {
                ss.setTopLevelScoringClause();
            }
        }
    }

    @Override
    public long cost() {
        if (this.cost == -1L) {
            this.cost = this.computeCost();
        }
        return this.cost;
    }

    @Override
    public Scorer get(long leadCost) throws IOException {
        Scorer scorer = this.getInternal(leadCost);
        if (this.scoreMode == ScoreMode.TOP_SCORES && this.subs.get((Object)BooleanClause.Occur.SHOULD).isEmpty() && this.subs.get((Object)BooleanClause.Occur.MUST).isEmpty()) {
            return scorer.twoPhaseIterator() != null ? new ConstantScoreScorer(this.weight, 0.0f, this.scoreMode, scorer.twoPhaseIterator()) : new ConstantScoreScorer(this.weight, 0.0f, this.scoreMode, scorer.iterator());
        }
        return scorer;
    }

    private Scorer getInternal(long leadCost) throws IOException {
        leadCost = Math.min(leadCost, this.cost());
        if (this.subs.get((Object)BooleanClause.Occur.SHOULD).isEmpty()) {
            return this.excl(this.req(this.subs.get((Object)BooleanClause.Occur.FILTER), this.subs.get((Object)BooleanClause.Occur.MUST), leadCost, this.topLevelScoringClause), this.subs.get((Object)BooleanClause.Occur.MUST_NOT), leadCost);
        }
        if (this.subs.get((Object)BooleanClause.Occur.FILTER).isEmpty() && this.subs.get((Object)BooleanClause.Occur.MUST).isEmpty()) {
            return this.excl(this.opt(this.subs.get((Object)BooleanClause.Occur.SHOULD), this.minShouldMatch, this.scoreMode, leadCost, this.topLevelScoringClause), this.subs.get((Object)BooleanClause.Occur.MUST_NOT), leadCost);
        }
        if (this.minShouldMatch > 0) {
            Scorer req = this.excl(this.req(this.subs.get((Object)BooleanClause.Occur.FILTER), this.subs.get((Object)BooleanClause.Occur.MUST), leadCost, false), this.subs.get((Object)BooleanClause.Occur.MUST_NOT), leadCost);
            Scorer opt = this.opt(this.subs.get((Object)BooleanClause.Occur.SHOULD), this.minShouldMatch, this.scoreMode, leadCost, false);
            return new ConjunctionScorer(this.weight, Arrays.asList(req, opt), Arrays.asList(req, opt));
        }
        assert (this.scoreMode.needsScores());
        return new ReqOptSumScorer(this.excl(this.req(this.subs.get((Object)BooleanClause.Occur.FILTER), this.subs.get((Object)BooleanClause.Occur.MUST), leadCost, false), this.subs.get((Object)BooleanClause.Occur.MUST_NOT), leadCost), this.opt(this.subs.get((Object)BooleanClause.Occur.SHOULD), this.minShouldMatch, this.scoreMode, leadCost, false), this.scoreMode);
    }

    private Scorer req(Collection<ScorerSupplier> requiredNoScoring, Collection<ScorerSupplier> requiredScoring, long leadCost, boolean topLevelScoringClause) throws IOException {
        if (requiredNoScoring.size() + requiredScoring.size() == 1) {
            Scorer req = (requiredNoScoring.isEmpty() ? requiredScoring : requiredNoScoring).iterator().next().get(leadCost);
            if (!this.scoreMode.needsScores()) {
                return req;
            }
            if (requiredScoring.isEmpty()) {
                return new FilterScorer(req){

                    @Override
                    public float score() throws IOException {
                        return 0.0f;
                    }

                    @Override
                    public float getMaxScore(int upTo) throws IOException {
                        return 0.0f;
                    }
                };
            }
            return req;
        }
        ArrayList<Scorer> requiredScorers = new ArrayList<Scorer>();
        List<Scorer> scoringScorers = new ArrayList<Scorer>();
        for (ScorerSupplier s2 : requiredNoScoring) {
            requiredScorers.add(s2.get(leadCost));
        }
        for (ScorerSupplier s2 : requiredScoring) {
            Scorer scorer = s2.get(leadCost);
            scoringScorers.add(scorer);
        }
        if (this.scoreMode == ScoreMode.TOP_SCORES && scoringScorers.size() > 1 && topLevelScoringClause) {
            BlockMaxConjunctionScorer blockMaxScorer = new BlockMaxConjunctionScorer(this.weight, scoringScorers);
            if (requiredScorers.isEmpty()) {
                return blockMaxScorer;
            }
            scoringScorers = Collections.singletonList(blockMaxScorer);
        }
        requiredScorers.addAll(scoringScorers);
        return new ConjunctionScorer(this.weight, requiredScorers, scoringScorers);
    }

    private Scorer excl(Scorer main, Collection<ScorerSupplier> prohibited, long leadCost) throws IOException {
        if (prohibited.isEmpty()) {
            return main;
        }
        return new ReqExclScorer(main, this.opt(prohibited, 1, ScoreMode.COMPLETE_NO_SCORES, leadCost, false));
    }

    private Scorer opt(Collection<ScorerSupplier> optional, int minShouldMatch, ScoreMode scoreMode, long leadCost, boolean topLevelScoringClause) throws IOException {
        if (optional.size() == 1) {
            return optional.iterator().next().get(leadCost);
        }
        ArrayList<Scorer> optionalScorers = new ArrayList<Scorer>();
        for (ScorerSupplier scorer : optional) {
            optionalScorers.add(scorer.get(leadCost));
        }
        if (scoreMode == ScoreMode.TOP_SCORES && topLevelScoringClause || minShouldMatch > 1) {
            return new WANDScorer(this.weight, optionalScorers, minShouldMatch, scoreMode);
        }
        return new DisjunctionSumScorer(this.weight, optionalScorers, scoreMode);
    }
}

