/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pt;

import org.apache.lucene.analysis.util.StemmerUtil;

public class PortugueseLightStemmer {
    public int stem(char[] s2, int len) {
        if (len < 4) {
            return len;
        }
        if ((len = this.removeSuffix(s2, len)) > 3 && s2[len - 1] == 'a') {
            len = this.normFeminine(s2, len);
        }
        if (len > 4) {
            switch (s2[len - 1]) {
                case 'a': 
                case 'e': 
                case 'o': {
                    --len;
                }
            }
        }
        block11: for (int i = 0; i < len; ++i) {
            switch (s2[i]) {
                case '\u00e0': 
                case '\u00e1': 
                case '\u00e2': 
                case '\u00e3': 
                case '\u00e4': {
                    s2[i] = 97;
                    continue block11;
                }
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f4': 
                case '\u00f5': 
                case '\u00f6': {
                    s2[i] = 111;
                    continue block11;
                }
                case '\u00e8': 
                case '\u00e9': 
                case '\u00ea': 
                case '\u00eb': {
                    s2[i] = 101;
                    continue block11;
                }
                case '\u00f9': 
                case '\u00fa': 
                case '\u00fb': 
                case '\u00fc': {
                    s2[i] = 117;
                    continue block11;
                }
                case '\u00ec': 
                case '\u00ed': 
                case '\u00ee': 
                case '\u00ef': {
                    s2[i] = 105;
                    continue block11;
                }
                case '\u00e7': {
                    s2[i] = 99;
                }
            }
        }
        return len;
    }

    private int removeSuffix(char[] s2, int len) {
        if (len > 4 && StemmerUtil.endsWith(s2, len, "es")) {
            switch (s2[len - 3]) {
                case 'l': 
                case 'r': 
                case 's': 
                case 'z': {
                    return len - 2;
                }
            }
        }
        if (len > 3 && StemmerUtil.endsWith(s2, len, "ns")) {
            s2[len - 2] = 109;
            return len - 1;
        }
        if (len > 4 && (StemmerUtil.endsWith(s2, len, "eis") || StemmerUtil.endsWith(s2, len, "\u00e9is"))) {
            s2[len - 3] = 101;
            s2[len - 2] = 108;
            return len - 1;
        }
        if (len > 4 && StemmerUtil.endsWith(s2, len, "ais")) {
            s2[len - 2] = 108;
            return len - 1;
        }
        if (len > 4 && StemmerUtil.endsWith(s2, len, "\u00f3is")) {
            s2[len - 3] = 111;
            s2[len - 2] = 108;
            return len - 1;
        }
        if (len > 4 && StemmerUtil.endsWith(s2, len, "is")) {
            s2[len - 1] = 108;
            return len;
        }
        if (len > 3 && (StemmerUtil.endsWith(s2, len, "\u00f5es") || StemmerUtil.endsWith(s2, len, "\u00e3es"))) {
            s2[--len - 2] = 227;
            s2[len - 1] = 111;
            return len;
        }
        if (len > 6 && StemmerUtil.endsWith(s2, len, "mente")) {
            return len - 5;
        }
        if (len > 3 && s2[len - 1] == 's') {
            return len - 1;
        }
        return len;
    }

    private int normFeminine(char[] s2, int len) {
        if (len > 7 && (StemmerUtil.endsWith(s2, len, "inha") || StemmerUtil.endsWith(s2, len, "iaca") || StemmerUtil.endsWith(s2, len, "eira"))) {
            s2[len - 1] = 111;
            return len;
        }
        if (len > 6) {
            if (StemmerUtil.endsWith(s2, len, "osa") || StemmerUtil.endsWith(s2, len, "ica") || StemmerUtil.endsWith(s2, len, "ida") || StemmerUtil.endsWith(s2, len, "ada") || StemmerUtil.endsWith(s2, len, "iva") || StemmerUtil.endsWith(s2, len, "ama")) {
                s2[len - 1] = 111;
                return len;
            }
            if (StemmerUtil.endsWith(s2, len, "ona")) {
                s2[len - 3] = 227;
                s2[len - 2] = 111;
                return len - 1;
            }
            if (StemmerUtil.endsWith(s2, len, "ora")) {
                return len - 1;
            }
            if (StemmerUtil.endsWith(s2, len, "esa")) {
                s2[len - 3] = 234;
                return len - 1;
            }
            if (StemmerUtil.endsWith(s2, len, "na")) {
                s2[len - 1] = 111;
                return len;
            }
        }
        return len;
    }
}

