/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.xloader;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.jena.tdb2.TDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkLoaderX {
    public static int DataTick = 1000000;
    public static int DataSuperTick = 10;
    public static final String StepMarker = "==-==-==";
    public static final String StageMarker = "==";
    public static boolean CompressDataFiles = true;
    public static boolean CompressSortNodeTableFiles = false;
    public static boolean CompressSortIndexFiles = true;
    public static Logger LOG_Data = LoggerFactory.getLogger("Data");
    public static Logger LOG_Nodes = LoggerFactory.getLogger("Nodes");
    public static Logger LOG_Terms = LoggerFactory.getLogger("Terms");
    public static Logger LOG_Index = LoggerFactory.getLogger("Index");

    static String gzipProgram() {
        if (BulkLoaderX.programInstalledAt("/usr/bin/gzip")) {
            return "/usr/bin/gzip";
        }
        if (BulkLoaderX.programInstalledAt("/bin/gzip")) {
            return "/bin/gzip";
        }
        throw new TDBException("Can't find gzip program");
    }

    private static boolean programInstalledAt(String pathname) {
        Path path = Path.of(pathname, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        if (!Files.isExecutable(path)) {
            throw new TDBException(pathname + " is not executable by this process");
        }
        return true;
    }

    public static Thread async(Runnable action, String threadName) {
        Objects.requireNonNull(action);
        Objects.requireNonNull(threadName);
        Thread thread = new Thread(action, threadName);
        thread.start();
        return thread;
    }

    public static void waitFor(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    public static String rateStr(long items, long elapsedMillis) {
        double xSec = (double)elapsedMillis / 1000.0;
        double rate = (double)items / xSec;
        return String.format("%,.0f", rate);
    }

    public static String milliToHMS(long milliSeconds) {
        long seconds;
        long z = seconds = milliSeconds / 1000L;
        long h2 = z / 3600L;
        long m4 = (z -= 3600L * h2) / 60L;
        long s2 = z -= 60L * m4;
        return String.format("%dh %02dm %02ds", h2, m4, s2);
    }
}

