/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import java.math.BigInteger;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionBase2;

public class Math_pow
extends FunctionBase2 {
    @Override
    public NodeValue exec(NodeValue v1, NodeValue v2) {
        switch (XSDFuncOp.classifyNumeric("pow", v1, v2)) {
            case OP_INTEGER: {
                BigInteger x = v1.getInteger();
                int y = v2.getInteger().intValue();
                if (y >= 0) {
                    return NodeValue.makeInteger(x.pow(y));
                }
            }
            case OP_DECIMAL: 
            case OP_FLOAT: 
            case OP_DOUBLE: {
                double d1 = v1.getDouble();
                double d2 = v2.getDouble();
                if (d1 == 1.0 && d2 == Double.POSITIVE_INFINITY) {
                    if (v1.isInteger()) {
                        return NodeValue.nvONE;
                    }
                    return NodeValue.makeDouble(1.0);
                }
                return NodeValue.makeDouble(Math.pow(v1.getDouble(), v2.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v1);
    }
}

