/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.binding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.ResultBinding;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingProjectNamed;

public class BindingLib {
    public static boolean equals(Binding bind1, Binding bind2) {
        if (bind1 == bind2) {
            return true;
        }
        if (bind1.size() != bind2.size()) {
            return false;
        }
        Iterator<Var> iter1 = bind1.vars();
        while (iter1.hasNext()) {
            Node node2;
            Var var = iter1.next();
            Node node1 = bind1.get(var);
            if (Objects.equals(node1, node2 = bind2.get(var))) continue;
            return false;
        }
        return true;
    }

    public static Binding merge(Binding bind1, Binding bind2) {
        BindingBuilder builder = Binding.builder(bind1);
        Iterator<Var> vIter = bind2.vars();
        while (vIter.hasNext()) {
            Node n2;
            Var v = vIter.next();
            if (!builder.contains(v)) {
                builder.add(v, bind2.get(v));
                continue;
            }
            Node n1 = bind1.get(v);
            if (n1.equals(n2 = bind2.get(v))) continue;
            Log.warn(BindingLib.class, "merge: Mismatch : " + n1 + " != " + n2);
        }
        return builder.build();
    }

    public static Map<Var, Node> bindingToMap(Binding binding) {
        HashMap<Var, Node> map = new HashMap<Var, Node>();
        binding.forEach(map::put);
        return map;
    }

    public static Binding asBinding(QuerySolution qSolution) {
        if (qSolution == null) {
            return null;
        }
        if (qSolution instanceof ResultBinding) {
            return new BindingProjectNamed(((ResultBinding)qSolution).getBinding());
        }
        Binding binding = BindingLib.toBinding(qSolution);
        return binding;
    }

    public static Binding toBinding(QuerySolution qSolution) {
        BindingBuilder builder = Binding.builder();
        Iterator<String> iter = qSolution.varNames();
        while (iter.hasNext()) {
            String n = iter.next();
            RDFNode x = qSolution.get(n);
            if (Var.isBlankNodeVarName(n)) continue;
            try {
                builder.add(Var.alloc(n), x.asNode());
            }
            catch (ARQInternalErrorException ex) {
                Log.warn(BindingLib.class, "Attempt to bind " + n + " when already bound");
            }
        }
        return builder.build();
    }
}

