/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.HashSet;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.mem.TupleTable;

public interface QuadTable
extends TupleTable<Quad> {
    public Stream<Quad> find(Node var1, Node var2, Node var3, Node var4);

    default public Stream<Node> listGraphNodes() {
        return this.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY).map(Quad::getGraph).distinct();
    }

    @Override
    default public void clear() {
        this.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY).forEach(this::delete);
    }

    default public Stream<Quad> findInUnionGraph(Node s2, Node p, Node o) {
        HashSet seen = new HashSet();
        return ((Stream)this.find(Node.ANY, s2, p, o).sequential()).filter(q -> !q.isDefaultGraph()).map(Quad::asTriple).filter(seen::add).map(t2 -> Quad.create(Quad.unionGraph, t2));
    }
}

