/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorConcat;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraphBaseFind;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.system.G;

public abstract class DatasetGraphCollection
extends DatasetGraphBaseFind {
    @Override
    public void add(Quad quad) {
        Graph g2 = this.fetchGraph(quad.getGraph());
        if (g2 == null) {
            throw new JenaException("No such graph: " + quad.getGraph());
        }
        g2.add(quad.asTriple());
    }

    @Override
    public void delete(Quad quad) {
        Graph g2 = this.fetchGraph(quad.getGraph());
        if (g2 == null) {
            throw new JenaException("No such graph: " + quad.getGraph());
        }
        g2.delete(quad.asTriple());
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s2, Node p, Node o) {
        return G.triples2quadsDftGraph(this.getDefaultGraph().find(s2, p, o));
    }

    protected Iter<Quad> findInSpecificNamedGraph(Node g2, Node s2, Node p, Node o) {
        Graph graph = this.fetchGraph(g2);
        if (graph == null) {
            return Iter.nullIter();
        }
        return G.triples2quads(g2, graph.find(s2, p, o));
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s2, Node p, Node o) {
        Iterator<Node> gnames = this.listGraphNodes();
        IteratorConcat<Quad> iter = new IteratorConcat<Quad>();
        while (gnames.hasNext()) {
            Node gn = gnames.next();
            Iterator qIter = this.findInSpecificNamedGraph(gn, s2, p, o);
            if (qIter == null) continue;
            iter.add(qIter);
        }
        return iter;
    }

    @Override
    public abstract Iterator<Node> listGraphNodes();

    @Override
    public void clear() {
        this.getDefaultGraph().clear();
        List<Node> gnList = Iter.toList(this.listGraphNodes());
        for (Node gn : gnList) {
            this.removeGraph(gn);
        }
    }

    protected Graph fetchGraph(Node gn) {
        if (Quad.isDefaultGraph(gn) || Objects.equals(gn, Quad.tripleInQuad)) {
            return this.getDefaultGraph();
        }
        return this.getGraph(gn);
    }
}

