/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpLib;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpQuadBlock
extends Op0 {
    private final QuadPattern quads;

    public static boolean isQuadBlock(Op op) {
        return op instanceof OpQuadBlock;
    }

    public static OpQuadBlock create(Node quadNode, BasicPattern triples) {
        QuadPattern qp = new QuadPattern();
        for (Triple t2 : triples) {
            qp.add(new Quad(quadNode, t2));
        }
        return new OpQuadBlock(qp);
    }

    public OpQuadBlock() {
        this.quads = new QuadPattern();
    }

    public OpQuadBlock(QuadPattern quads) {
        this.quads = quads;
    }

    public OpQuadBlock(OpQuadPattern quadPattern) {
        this.quads = quadPattern.getPattern();
    }

    public QuadPattern getPattern() {
        return this.quads;
    }

    public boolean isEmpty() {
        return this.quads.size() == 0;
    }

    @Override
    public String getName() {
        return "quadblock";
    }

    @Override
    public Op apply(Transform transform) {
        return transform.transform(this);
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op0 copy() {
        return new OpQuadBlock(this.quads);
    }

    public List<OpQuadPattern> convert() {
        ArrayList<OpQuadPattern> x = new ArrayList<OpQuadPattern>();
        Node gn = null;
        BasicPattern bgp = null;
        for (Quad q : this.quads) {
            if (gn == null || !gn.equals(q.getGraph())) {
                if (gn != null) {
                    x.add(new OpQuadPattern(gn, bgp));
                }
                gn = q.getGraph();
                bgp = new BasicPattern();
            }
            bgp.add(q.asTriple());
        }
        x.add(new OpQuadPattern(gn, bgp));
        return x;
    }

    public Op convertOp() {
        if (this.quads.size() == 0) {
            return OpLib.empty();
        }
        if (this.quads.size() == 1) {
            Quad q = this.quads.get(0);
            BasicPattern bgp = new BasicPattern();
            bgp.add(q.asTriple());
            return new OpQuadPattern(q.getGraph(), bgp);
        }
        List<OpQuadPattern> x = this.convert();
        OpSequence ops = OpSequence.create();
        for (OpQuadPattern oqp : x) {
            ops.add(oqp);
        }
        return ops;
    }

    @Override
    public int hashCode() {
        int calcHashCode = 177;
        return calcHashCode ^= this.quads.hashCode();
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpQuadBlock)) {
            return false;
        }
        OpQuadBlock opQuad = (OpQuadBlock)other;
        return this.quads.equiv(opQuad.quads, labelMap);
    }
}

