/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation;

import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.sys.C;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.shacl.vocabulary.SHACLM;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

public class VR {
    private static Model conformsModel = ModelFactory.createDefaultModel();
    private static String PREFIXES;
    private static String qs;
    private static Query query;
    static Set<Property> properties;

    public static boolean compare(ValidationReport report1, ValidationReport report2) {
        Model m1 = VR.strip(report1.getResource().getModel());
        Model m22 = VR.strip(report2.getResource().getModel());
        return m1.isIsomorphicWith(m22);
    }

    public static Model conformsModel() {
        return ModelFactory.createDefaultModel().add(conformsModel);
    }

    public static void check(ValidationReport report) {
        ValidationReport report2;
        Model m22;
        Model m4 = report.getResource().getModel();
        boolean b = m4.isIsomorphicWith(m22 = (report2 = ValidationReport.fromModel(m4)).getResource().getModel());
        if (!b) {
            System.err.println("****");
            RDFDataMgr.write((OutputStream)System.err, m4, Lang.TTL);
            System.err.println("++++ Round trip");
            RDFDataMgr.write((OutputStream)System.err, m22, Lang.TTL);
            System.err.println("----");
        }
    }

    private static void prefixes(PrefixMapping pmap) {
        pmap.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        pmap.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        pmap.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        pmap.setNsPrefix("sh", "http://www.w3.org/ns/shacl#");
        pmap.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
    }

    public static Model strip(Model model) {
        ExtendedIterator<Statement> iter = model.listStatements().filterKeep(stmt -> VR.keep(stmt));
        Model m4 = ModelFactory.createDefaultModel();
        iter.forEachRemaining(stmt -> m4.add((Statement)stmt));
        VR.prefixes(m4);
        Graph graph = model.getGraph();
        Graph g2 = m4.getGraph();
        G.find(graph, null, SHACL.resultPath, null).toList().forEach(t2 -> {
            Node obj = t2.getObject();
            Node pn = ShaclPaths.copyPath(graph, g2, obj);
            g2.add(Triple.create(t2.getSubject(), t2.getPredicate(), pn));
        });
        return m4;
    }

    private static boolean keep(Statement stmt) {
        Property p = stmt.getPredicate();
        if (properties.contains(p)) {
            return true;
        }
        return p.equals(RDF.type) && SHACLM.ValidationReport.equals(stmt.getObject());
    }

    static {
        Resource report = conformsModel.createResource(SHACLM.ValidationReport);
        report.addProperty(SHACLM.conforms, C.mTRUE);
        PREFIXES = StrUtils.strjoinNL("PREFIX owl:  <http://www.w3.org/2002/07/owl#>", "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX sh:   <http://www.w3.org/ns/shacl#>", "PREFIX xsd:  <http://www.w3.org/2001/XMLSchema#>", "");
        qs = StrUtils.strjoinNL(PREFIXES, "CONSTRUCT {", "    ?X a sh:ValidationReport ;", "        sh:conforms ?conforms ;", "        sh:result ?R", "    .", "    ?R", "       sh:focusNode ?focusNode ;", "       sh:resultMessage ?message ;", "       sh:resultSeverity  ?severity ; ", "       sh:sourceConstraint ?constraint ;", "       sh:sourceConstraintComponent ?component ;", "       sh:sourceShape ?sourceShape ;", "       sh:resultPath  ?path ;", "       sh:value ?value ;", ".", "}", " WHERE {", "    ?X a sh:ValidationReport ;", "       sh:result ?R", "    OPTIONAL { ?X sh:conforms ?conforms }", "    ?R", "       sh:focusNode ?focusNode ;", "       sh:resultSeverity  ?severity ; ", "       .", "    OPTIONAL { ?R sh:resultMessage ?message }", "    OPTIONAL { ?R sh:sourceConstraintComponent ?component }", "    OPTIONAL { ?R sh:sourceConstraint ?constraint }", "    OPTIONAL { ?R sh:sourceShape ?sourceShape }", "    OPTIONAL { ?R sh:resultPath  ?path }", "    OPTIONAL { ?R sh:value ?value }", "}");
        query = QueryFactory.create(qs);
        properties = new HashSet<Property>();
        properties.add(SHACLM.result);
        properties.add(SHACLM.conforms);
        properties.add(SHACLM.focusNode);
        properties.add(SHACLM.resultSeverity);
        properties.add(SHACLM.sourceConstraintComponent);
        properties.add(SHACLM.value);
    }
}

