/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.thrift.ThriftConvert;
import org.apache.jena.riot.thrift.VisitorStreamRowTRDF;
import org.apache.jena.riot.thrift.wire.RDF_PrefixDecl;
import org.apache.jena.riot.thrift.wire.RDF_Quad;
import org.apache.jena.riot.thrift.wire.RDF_Triple;
import org.apache.jena.sparql.core.Quad;

public class Thrift2StreamRDF
implements VisitorStreamRowTRDF {
    private final StreamRDF dest;
    private final PrefixMap pmap;
    private final Cache<String, Node> uriCache = CacheFactory.createSimpleCache(5000);

    public Thrift2StreamRDF(PrefixMap pmap, StreamRDF stream) {
        this.pmap = pmap;
        this.dest = stream;
    }

    @Override
    public void visit(RDF_Triple rt) {
        Triple t2 = ThriftConvert.convert(this.uriCache, rt, this.pmap);
        this.dest.triple(t2);
    }

    @Override
    public void visit(RDF_Quad rq) {
        Quad q = ThriftConvert.convert(this.uriCache, rq, this.pmap);
        this.dest.quad(q);
    }

    @Override
    public void visit(RDF_PrefixDecl prefixDecl) {
        String prefix = prefixDecl.getPrefix();
        String iriStr = prefixDecl.getUri();
        this.pmap.add(prefix, iriStr);
        this.dest.prefix(prefix, iriStr);
    }
}

