/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.util.List;
import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Node_ANY;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.Builtin;
import org.apache.jena.reasoner.rulesys.BuiltinRegistry;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.FunctorDatatype;
import org.apache.jena.reasoner.rulesys.Node_RuleVariable;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.util.PrintUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Functor
implements ClauseEntry {
    protected String name;
    protected Node[] args;
    protected Builtin implementor;
    public static final Predicate<Triple> acceptFilter = t2 -> {
        if (t2.getSubject().isLiteral()) {
            return true;
        }
        Node n = t2.getObject();
        return n.isLiteral() && n.getLiteralDatatype() == FunctorDatatype.theFunctorDatatype;
    };
    protected static Logger logger = LoggerFactory.getLogger(Functor.class);

    public Functor(String name, Node[] args) {
        this.name = name;
        this.args = args;
    }

    public Functor(String name, List<Node> args, BuiltinRegistry registry) {
        this(name, args, registry.getImplementation(name));
    }

    public Functor(String name, Node[] args, BuiltinRegistry registry) {
        this(name, args, registry.getImplementation(name));
    }

    public Functor(String name, List<Node> args, Builtin impl) {
        this.name = name;
        this.args = args.toArray(new Node[0]);
        this.implementor = impl;
    }

    public Functor(String name, Node[] args, Builtin impl) {
        this.name = name;
        this.args = args;
        this.implementor = impl;
    }

    public String getName() {
        return this.name;
    }

    public Node[] getArgs() {
        return this.args;
    }

    public int getArgLength() {
        return this.args.length;
    }

    public boolean isGround() {
        for (Node n : this.args) {
            if (!(n instanceof Node_RuleVariable) && !(n instanceof Node_ANY)) continue;
            return false;
        }
        return true;
    }

    public boolean isGround(BindingEnvironment env) {
        for (Node n : this.args) {
            if (!env.getGroundVersion(n).isVariable()) continue;
            return false;
        }
        return true;
    }

    public boolean evalAsBodyClause(RuleContext context2) {
        if (this.getImplementor() == null) {
            logger.warn("Invoking undefined functor " + this.getName() + " in " + context2.getRule().toShortString());
            return false;
        }
        return this.implementor.bodyCall(this.getBoundArgs(context2.getEnv()), this.args.length, context2);
    }

    public boolean safeEvalAsBodyClause(RuleContext context2) {
        if (this.getImplementor() == null) {
            logger.warn("Invoking undefined functor " + this.getName() + " in " + context2.getRule().toShortString());
            return false;
        }
        if (this.implementor.isSafe()) {
            return this.implementor.bodyCall(this.getBoundArgs(context2.getEnv()), this.args.length, context2);
        }
        return false;
    }

    public Node[] getBoundArgs(BindingEnvironment env) {
        Node[] boundargs = new Node[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            boundargs[i] = env.getGroundVersion(this.args[i]);
        }
        return boundargs;
    }

    public Builtin getImplementor() {
        if (this.implementor == null) {
            this.implementor = BuiltinRegistry.theRegistry.getImplementation(this.name);
        }
        return this.implementor;
    }

    public void setImplementor(Builtin implementor) {
        this.implementor = implementor;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(this.name);
        buff.append("(");
        for (int i = 0; i < this.args.length; ++i) {
            buff.append(PrintUtil.print(this.args[i]));
            if (i >= this.args.length - 1) continue;
            buff.append(" ");
        }
        buff.append(")");
        return buff.toString();
    }

    public static boolean isFunctor(Node n) {
        if (n == null) {
            return false;
        }
        return n.isLiteral() && n.getLiteralDatatype() == FunctorDatatype.theFunctorDatatype;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Functor) {
            Functor f2 = (Functor)obj;
            if (this.name.equals(f2.name) && this.args.length == f2.args.length) {
                for (int i = 0; i < this.args.length; ++i) {
                    if (this.args[i].sameValueAs(f2.args[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.args.length << 2;
    }

    @Override
    public boolean sameAs(Object o) {
        if (o instanceof Functor) {
            Functor f2 = (Functor)o;
            if (this.name.equals(f2.name) && this.args.length == f2.args.length) {
                for (int i = 0; i < this.args.length; ++i) {
                    if (Node_RuleVariable.sameNodeAs(this.args[i], f2.args[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static Node makeFunctorNode(String name, Node[] args) {
        return Functor.makeFunctorNode(new Functor(name, args, BuiltinRegistry.theRegistry));
    }

    public static Node makeFunctorNode(Functor f) {
        return NodeFactory.createLiteralByValue(f, FunctorDatatype.theFunctorDatatype);
    }
}

