/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmloutput.impl;

import java.io.PrintWriter;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.rdfxml.xmloutput.impl.BaseXMLWriter;
import org.apache.jena.vocabulary.RDFSyntax;

public class RDFXML_Basic
extends BaseXMLWriter {
    private String space;
    private boolean blockLiterals = false;

    @Override
    protected void writeBody(Model model, PrintWriter pw, String base, boolean inclXMLBase) {
        this.setSpaceFromTabCount();
        this.writeRDFHeader(model, pw);
        this.writeRDFStatements(model, pw);
        this.writeRDFTrailer(pw, base);
        pw.flush();
    }

    private void setSpaceFromTabCount() {
        this.space = "";
        for (int i = 0; i < this.tabSize; ++i) {
            this.space = this.space + " ";
        }
    }

    protected void writeSpace(PrintWriter writer) {
        writer.print(this.space);
    }

    private void writeRDFHeader(Model model, PrintWriter writer) {
        String xmlns = this.xmlnsDecl();
        writer.print("<" + this.rdfEl("RDF") + xmlns);
        if (null != this.xmlBase && this.xmlBase.length() > 0) {
            writer.print("\n  xml:base=" + this.substitutedAttribute(this.xmlBase));
        }
        writer.println(" > ");
    }

    protected void writeRDFStatements(Model model, PrintWriter writer) {
        ResIterator rIter = model.listSubjects();
        while (rIter.hasNext()) {
            this.writeRDFStatements(model, rIter.nextResource(), writer);
        }
    }

    protected void writeRDFTrailer(PrintWriter writer, String base) {
        writer.println("</" + this.rdfEl("RDF") + ">");
    }

    protected void writeRDFStatements(Model model, Resource subject, PrintWriter writer) {
        StmtIterator sIter = model.listStatements(subject, null, (RDFNode)null);
        this.writeDescriptionHeader(subject, writer);
        while (sIter.hasNext()) {
            this.writePredicate(sIter.nextStatement(), writer);
        }
        this.writeDescriptionTrailer(subject, writer);
    }

    protected void writeDescriptionHeader(Resource subject, PrintWriter writer) {
        writer.print(this.space + "<" + this.rdfEl("Description") + " ");
        this.writeResourceId(subject, writer);
        writer.println(">");
    }

    protected void writePredicate(Statement stmt, PrintWriter writer) {
        Property predicate = stmt.getPredicate();
        RDFNode object = stmt.getObject();
        writer.print(this.space + this.space + "<" + this.startElementTag(predicate.getNameSpace(), predicate.getLocalName()));
        if (object instanceof Resource) {
            writer.print(" ");
            this.writeResourceReference((Resource)object, writer);
            writer.println("/>");
        } else {
            this.writeLiteral((Literal)object, writer);
            writer.println("</" + this.endElementTag(predicate.getNameSpace(), predicate.getLocalName()) + ">");
        }
    }

    @Override
    protected void unblockAll() {
        this.blockLiterals = false;
    }

    @Override
    protected void blockRule(Resource r) {
        if (r.equals(RDFSyntax.parseTypeLiteralPropertyElt)) {
            this.blockLiterals = true;
        } else {
            logger.warn("Cannot block rule <" + r.getURI() + ">");
        }
    }

    protected void writeDescriptionTrailer(Resource subject, PrintWriter writer) {
        writer.println(this.space + "</" + this.rdfEl("Description") + ">");
    }

    protected void writeResourceId(Resource r, PrintWriter writer) {
        if (r.isAnon()) {
            writer.print(this.rdfAt("nodeID") + "=" + this.attributeQuoted(this.anonId(r)));
        } else {
            writer.print(this.rdfAt("about") + "=" + this.substitutedAttribute(this.relativize(r.getURI())));
        }
    }

    protected void writeResourceReference(Resource r, PrintWriter writer) {
        if (r.isAnon()) {
            writer.print(this.rdfAt("nodeID") + "=" + this.attributeQuoted(this.anonId(r)));
        } else {
            writer.print(this.rdfAt("resource") + "=" + this.substitutedAttribute(this.relativize(r.getURI())));
        }
    }

    protected void writeLiteral(Literal l, PrintWriter writer) {
        String lang = l.getLanguage();
        String form = l.getLexicalForm();
        boolean isXML = XMLLiteralType.theXMLLiteralType.equals(l.getDatatype());
        if (Util.isLangString(l)) {
            writer.print(" xml:lang=" + this.attributeQuoted(lang));
        } else {
            if (isXML && !this.blockLiterals) {
                writer.print(" " + this.rdfAt("parseType") + "=" + this.attributeQuoted("Literal") + ">");
                writer.print(form);
                return;
            }
            String dt = l.getDatatypeURI();
            if (!Util.isSimpleString(l)) {
                writer.print(" " + this.rdfAt("datatype") + "=" + this.substitutedAttribute(dt));
            }
        }
        writer.print(">");
        writer.print(Util.substituteEntitiesInElementContent(form));
    }
}

