/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.text;

import java.io.OutputStream;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.rdfpatch.text.TokenWriter;
import org.apache.jena.rdfpatch.text.TokenWriterText;
import org.apache.jena.sparql.core.Quad;

public class RDFChangesWriterText
implements RDFChanges,
AutoCloseable {
    protected TokenWriter tok;

    public static RDFChangesWriterText create(OutputStream out) {
        return new RDFChangesWriterText(TokenWriterText.create(out));
    }

    public RDFChangesWriterText(TokenWriter out) {
        this.tok = out;
    }

    @Override
    public void start() {
    }

    @Override
    public void finish() {
        this.tok.flush();
    }

    @Override
    public void header(String field, Node value) {
        this.tok.startTuple();
        this.tok.sendWord("H");
        this.tok.sendWord(field);
        this.output(value);
        this.tok.endTuple();
    }

    @Override
    public void close() {
        this.tok.close();
    }

    @Override
    public void add(Node g2, Node s2, Node p, Node o) {
        this.output("A", g2, s2, p, o);
    }

    private void output(String code, Node g2, Node s2, Node p, Node o) {
        this.tok.startTuple();
        this.outputWord(code);
        this.output(s2);
        this.output(p);
        this.output(o);
        if (g2 != null && !Quad.isDefaultGraph(g2)) {
            this.output(g2);
        }
        this.tok.endTuple();
    }

    private void output(Node node) {
        this.tok.sendNode(node);
    }

    private void outputWord(String code) {
        this.tok.sendWord(code);
    }

    @Override
    public void delete(Node g2, Node s2, Node p, Node o) {
        this.output("D", g2, s2, p, o);
    }

    @Override
    public void addPrefix(Node gn, String prefix, String uriStr) {
        this.tok.startTuple();
        this.outputWord("PA");
        this.tok.sendString(prefix);
        this.tok.sendString(uriStr);
        if (gn != null) {
            this.tok.sendNode(gn);
        }
        this.tok.endTuple();
    }

    @Override
    public void deletePrefix(Node gn, String prefix) {
        this.tok.startTuple();
        this.outputWord("PD");
        this.tok.sendString(prefix);
        if (gn != null) {
            this.tok.sendNode(gn);
        }
        this.tok.endTuple();
    }

    private void oneline(String code) {
        this.tok.startTuple();
        this.tok.sendWord(code);
        this.tok.endTuple();
    }

    @Override
    public void txnBegin() {
        this.oneline("TX");
    }

    @Override
    public void txnCommit() {
        this.oneline("TC");
        this.tok.flush();
    }

    @Override
    public void txnAbort() {
        this.oneline("TA");
        this.tok.flush();
    }

    @Override
    public void segment() {
        this.oneline("Z");
    }
}

