/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.filelog;

import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.rdfpatch.filelog.rotate.FileRotateException;

public enum FilePolicy {
    DATE,
    TIMESTAMP,
    INDEX,
    SHIFT,
    FIXED;


    public static FilePolicy policy(String name) {
        String nameLC;
        Objects.requireNonNull(name);
        switch (nameLC = Lib.lowercase(name)) {
            case "date": {
                return DATE;
            }
            case "timestamp": {
                return TIMESTAMP;
            }
            case "index": {
                return INDEX;
            }
            case "rotate": {
                return SHIFT;
            }
            case "shift": {
                return SHIFT;
            }
            case "fixed": {
                return FIXED;
            }
            case "none": {
                return FIXED;
            }
        }
        throw new FileRotateException("Unknown policy name: " + name);
    }
}

