/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.MinCardinalityRestriction;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.impl.RestrictionImpl;

public class MinCardinalityRestrictionImpl
extends RestrictionImpl
implements MinCardinalityRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new MinCardinalityRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to MinCardinalityRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, MinCardinalityRestriction.class);
        }
    };

    public MinCardinalityRestrictionImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setMinCardinality(int cardinality) {
        this.setPropertyValue(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public int getMinCardinality() {
        return this.objectAsInt(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY");
    }

    @Override
    public boolean hasMinCardinality(int cardinality) {
        return this.hasPropertyValue(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public void removeMinCardinality(int cardinality) {
        this.removePropertyValue(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }
}

