/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.store.legacy;

import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem2.iterator.IteratorOfJenaSets;
import org.apache.jena.mem2.store.legacy.ArrayBunch;
import org.apache.jena.mem2.store.legacy.FieldFilter;
import org.apache.jena.mem2.store.legacy.HashedBunchMap;
import org.apache.jena.mem2.store.legacy.HashedTripleBunch;
import org.apache.jena.mem2.store.legacy.NodeToTriplesMap;
import org.apache.jena.mem2.store.legacy.TripleBunch;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class NodeToTriplesMapMem
implements NodeToTriplesMap {
    private final HashedBunchMap bunchMap;
    private final Triple.Field indexField;
    private final Triple.Field f2;
    private final Triple.Field f3;
    private int size = 0;

    public NodeToTriplesMapMem(Triple.Field indexField, Triple.Field f2, Triple.Field f3) {
        this.indexField = indexField;
        this.f2 = f2;
        this.f3 = f3;
        this.bunchMap = new HashedBunchMap();
    }

    private NodeToTriplesMapMem(NodeToTriplesMapMem mapToCopy) {
        this.indexField = mapToCopy.indexField;
        this.f2 = mapToCopy.f2;
        this.f3 = mapToCopy.f3;
        this.size = mapToCopy.size;
        this.bunchMap = mapToCopy.bunchMap.copy();
    }

    private Node getIndexNode(Triple t2) {
        return this.indexField.getField(t2);
    }

    @Override
    public void clear() {
        this.bunchMap.clear();
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean tryAdd(Triple t2) {
        Node node = this.getIndexNode(t2);
        TripleBunch s2 = (TripleBunch)this.bunchMap.get(node);
        if (s2 == null) {
            s2 = new ArrayBunch();
            this.bunchMap.put(node, s2);
            s2.addUnchecked(t2);
            ++this.size;
            return true;
        }
        if (s2.isArray() && s2.size() == 9) {
            s2 = new HashedTripleBunch(s2);
            this.bunchMap.put(node, s2);
        }
        if (s2.tryAdd(t2)) {
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public void addUnchecked(Triple t2) {
        Node node = this.getIndexNode(t2);
        TripleBunch s2 = (TripleBunch)this.bunchMap.get(node);
        if (s2 == null) {
            s2 = new ArrayBunch();
            this.bunchMap.put(node, s2);
        } else if (s2.isArray() && s2.size() == 9) {
            s2 = new HashedTripleBunch(s2);
            this.bunchMap.put(node, s2);
        }
        s2.addUnchecked(t2);
        ++this.size;
    }

    @Override
    public boolean tryRemove(Triple t2) {
        Node node = this.getIndexNode(t2);
        TripleBunch s2 = (TripleBunch)this.bunchMap.get(node);
        if (s2 == null) {
            return false;
        }
        if (s2.tryRemove(t2)) {
            --this.size;
            if (s2.isEmpty()) {
                this.bunchMap.removeUnchecked(node);
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeUnchecked(Triple t2) {
        Node node = this.getIndexNode(t2);
        TripleBunch s2 = (TripleBunch)this.bunchMap.get(node);
        if (s2 == null) {
            return;
        }
        s2.removeUnchecked(t2);
        --this.size;
        if (s2.isEmpty()) {
            this.bunchMap.removeUnchecked(node);
        }
    }

    @Override
    public ExtendedIterator<Triple> keyIterator() {
        return new IteratorOfJenaSets<Triple>(this.bunchMap.valueIterator());
    }

    @Override
    public Spliterator<Triple> keySpliterator() {
        return this.keyStream().spliterator();
    }

    @Override
    public Stream<Triple> keyStream() {
        return StreamSupport.stream(this.bunchMap.valueSpliterator(), false).flatMap(bunch -> StreamSupport.stream(bunch.keySpliterator(), false));
    }

    @Override
    public ExtendedIterator<Triple> iteratorForMatches(Node index, Node n2, Node n3) {
        TripleBunch s2 = (TripleBunch)this.bunchMap.get(index);
        if (s2 == null) {
            return NullIterator.instance();
        }
        FieldFilter filter = FieldFilter.filterOn(this.f2, n2, this.f3, n3);
        return filter.hasFilter() ? s2.keyIterator().filterKeep(filter.getFilter()) : s2.keyIterator();
    }

    @Override
    public Stream<Triple> streamForMatches(Node index, Node n2, Node n3) {
        TripleBunch s2 = (TripleBunch)this.bunchMap.get(index);
        if (s2 == null) {
            return Stream.empty();
        }
        FieldFilter filter = FieldFilter.filterOn(this.f2, n2, this.f3, n3);
        return filter.hasFilter() ? StreamSupport.stream(s2.keySpliterator(), false).filter(filter.getFilter()) : StreamSupport.stream(s2.keySpliterator(), false);
    }

    @Override
    public boolean containsMatch(Node index, Node n2, Node n3) {
        TripleBunch s2 = (TripleBunch)this.bunchMap.get(index);
        if (s2 == null) {
            return false;
        }
        FieldFilter filter = FieldFilter.filterOn(this.f2, n2, this.f3, n3);
        if (!filter.hasFilter()) {
            return true;
        }
        return s2.anyMatch(filter.getFilter());
    }

    @Override
    public NodeToTriplesMapMem copy() {
        return new NodeToTriplesMapMem(this);
    }

    @Override
    public boolean containsKey(Triple triple) {
        TripleBunch s2 = (TripleBunch)this.bunchMap.get(this.getIndexNode(triple));
        if (s2 == null) {
            return false;
        }
        return s2.containsKey(triple);
    }

    @Override
    public boolean anyMatch(Predicate<Triple> predicate) {
        return this.bunchMap.valueStream().anyMatch((? super T bunch) -> bunch.anyMatch(predicate));
    }
}

