/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.store.fast;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem2.iterator.IteratorOfJenaSets;
import org.apache.jena.mem2.pattern.PatternClassifier;
import org.apache.jena.mem2.store.TripleStore;
import org.apache.jena.mem2.store.fast.FastArrayBunch;
import org.apache.jena.mem2.store.fast.FastHashedBunchMap;
import org.apache.jena.mem2.store.fast.FastHashedTripleBunch;
import org.apache.jena.mem2.store.fast.FastTripleBunch;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.SingletonIterator;

public class FastTripleStore
implements TripleStore {
    protected static final int THRESHOLD_FOR_SECONDARY_LOOKUP = 400;
    protected static final int MAX_ARRAY_BUNCH_SIZE_SUBJECT = 16;
    protected static final int MAX_ARRAY_BUNCH_SIZE_PREDICATE_OBJECT = 32;
    final FastHashedBunchMap subjects;
    final FastHashedBunchMap predicates;
    final FastHashedBunchMap objects;
    private int size = 0;

    public FastTripleStore() {
        this.subjects = new FastHashedBunchMap();
        this.predicates = new FastHashedBunchMap();
        this.objects = new FastHashedBunchMap();
    }

    private FastTripleStore(FastTripleStore tripleStoreToCopy) {
        this.subjects = tripleStoreToCopy.subjects.copy();
        this.predicates = tripleStoreToCopy.predicates.copy();
        this.objects = tripleStoreToCopy.objects.copy();
        this.size = tripleStoreToCopy.size;
    }

    @Override
    public void add(Triple triple) {
        boolean added;
        int hashCodeOfTriple = triple.hashCode();
        FastTripleBunch sBunch = (FastTripleBunch)this.subjects.get(triple.getSubject());
        if (sBunch == null) {
            sBunch = new ArrayBunchWithSameSubject();
            sBunch.addUnchecked(triple, hashCodeOfTriple);
            this.subjects.put(triple.getSubject(), sBunch);
            added = true;
        } else {
            if (sBunch.isArray() && sBunch.size() == 16) {
                sBunch = new FastHashedTripleBunch(sBunch);
                this.subjects.put(triple.getSubject(), sBunch);
            }
            added = sBunch.tryAdd(triple, hashCodeOfTriple);
        }
        if (added) {
            ++this.size;
            FastTripleBunch pBunch = this.predicates.computeIfAbsent(triple.getPredicate(), ArrayBunchWithSamePredicate::new);
            if (pBunch.isArray() && pBunch.size() == 32) {
                pBunch = new FastHashedTripleBunch(pBunch);
                this.predicates.put(triple.getPredicate(), pBunch);
            }
            pBunch.addUnchecked(triple, hashCodeOfTriple);
            FastTripleBunch oBunch = this.objects.computeIfAbsent(triple.getObject(), ArrayBunchWithSameObject::new);
            if (oBunch.isArray() && oBunch.size() == 32) {
                oBunch = new FastHashedTripleBunch(oBunch);
                this.objects.put(triple.getObject(), oBunch);
            }
            oBunch.addUnchecked(triple, hashCodeOfTriple);
        }
    }

    @Override
    public void remove(Triple triple) {
        int hashCodeOfTriple = triple.hashCode();
        FastTripleBunch sBunch = (FastTripleBunch)this.subjects.get(triple.getSubject());
        if (sBunch == null) {
            return;
        }
        if (sBunch.tryRemove(triple, hashCodeOfTriple)) {
            if (sBunch.isEmpty()) {
                this.subjects.removeUnchecked(triple.getSubject());
            }
            FastTripleBunch pBunch = (FastTripleBunch)this.predicates.get(triple.getPredicate());
            pBunch.removeUnchecked(triple, hashCodeOfTriple);
            if (pBunch.isEmpty()) {
                this.predicates.removeUnchecked(triple.getPredicate());
            }
            FastTripleBunch oBunch = (FastTripleBunch)this.objects.get(triple.getObject());
            oBunch.removeUnchecked(triple, hashCodeOfTriple);
            if (oBunch.isEmpty()) {
                this.objects.removeUnchecked(triple.getObject());
            }
            --this.size;
        }
    }

    @Override
    public void clear() {
        this.subjects.clear();
        this.predicates.clear();
        this.objects.clear();
        this.size = 0;
    }

    @Override
    public int countTriples() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Triple tripleMatch) {
        switch (PatternClassifier.classify(tripleMatch)) {
            case SUB_PRE_OBJ: {
                FastTripleBunch triples = (FastTripleBunch)this.subjects.get(tripleMatch.getSubject());
                if (triples == null) {
                    return false;
                }
                return triples.containsKey(tripleMatch);
            }
            case SUB_PRE_ANY: {
                FastTripleBunch triplesBySubject = (FastTripleBunch)this.subjects.get(tripleMatch.getSubject());
                if (triplesBySubject == null) {
                    return false;
                }
                return triplesBySubject.anyMatch(t2 -> tripleMatch.getPredicate().equals(t2.getPredicate()));
            }
            case SUB_ANY_OBJ: {
                FastTripleBunch triplesBySubject = (FastTripleBunch)this.subjects.get(tripleMatch.getSubject());
                if (triplesBySubject == null) {
                    return false;
                }
                return triplesBySubject.anyMatch(t2 -> tripleMatch.getObject().equals(t2.getObject()));
            }
            case SUB_ANY_ANY: {
                return this.subjects.containsKey(tripleMatch.getSubject());
            }
            case ANY_PRE_OBJ: {
                FastTripleBunch triplesByObject = (FastTripleBunch)this.objects.get(tripleMatch.getObject());
                if (triplesByObject == null) {
                    return false;
                }
                if (triplesByObject.size() > 400) {
                    FastTripleBunch triplesByPredicate = (FastTripleBunch)this.predicates.get(tripleMatch.getPredicate());
                    if (triplesByPredicate == null) {
                        return false;
                    }
                    if (triplesByPredicate.size() < triplesByObject.size()) {
                        return triplesByPredicate.anyMatchRandomOrder(t2 -> tripleMatch.getObject().equals(t2.getObject()));
                    }
                }
                return triplesByObject.anyMatchRandomOrder(t2 -> tripleMatch.getPredicate().equals(t2.getPredicate()));
            }
            case ANY_PRE_ANY: {
                return this.predicates.containsKey(tripleMatch.getPredicate());
            }
            case ANY_ANY_OBJ: {
                return this.objects.containsKey(tripleMatch.getObject());
            }
            case ANY_ANY_ANY: {
                return !this.isEmpty();
            }
        }
        throw new IllegalStateException(String.format("Unexpected value: %s", new Object[]{PatternClassifier.classify(tripleMatch)}));
    }

    @Override
    public Stream<Triple> stream() {
        return StreamSupport.stream(this.subjects.valueSpliterator(), false).flatMap(bunch -> StreamSupport.stream(bunch.keySpliterator(), false));
    }

    @Override
    public Stream<Triple> stream(Triple tripleMatch) {
        switch (PatternClassifier.classify(tripleMatch)) {
            case SUB_PRE_OBJ: {
                FastTripleBunch triples = (FastTripleBunch)this.subjects.get(tripleMatch.getSubject());
                if (triples == null) {
                    return Stream.empty();
                }
                return triples.containsKey(tripleMatch) ? Stream.of(tripleMatch) : Stream.empty();
            }
            case SUB_PRE_ANY: {
                FastTripleBunch triplesBySubject = (FastTripleBunch)this.subjects.get(tripleMatch.getSubject());
                if (triplesBySubject == null) {
                    return Stream.empty();
                }
                return triplesBySubject.keyStream().filter(t2 -> tripleMatch.getPredicate().equals(t2.getPredicate()));
            }
            case SUB_ANY_OBJ: {
                FastTripleBunch triplesBySubject = (FastTripleBunch)this.subjects.get(tripleMatch.getSubject());
                if (triplesBySubject == null) {
                    return Stream.empty();
                }
                return triplesBySubject.keyStream().filter(t2 -> tripleMatch.getObject().equals(t2.getObject()));
            }
            case SUB_ANY_ANY: {
                FastTripleBunch triples = (FastTripleBunch)this.subjects.get(tripleMatch.getSubject());
                return triples == null ? Stream.empty() : triples.keyStream();
            }
            case ANY_PRE_OBJ: {
                FastTripleBunch triplesByObject = (FastTripleBunch)this.objects.get(tripleMatch.getObject());
                if (triplesByObject == null) {
                    return Stream.empty();
                }
                if (triplesByObject.size() > 400) {
                    FastTripleBunch triplesByPredicate = (FastTripleBunch)this.predicates.get(tripleMatch.getPredicate());
                    if (triplesByPredicate == null) {
                        return Stream.empty();
                    }
                    if (triplesByPredicate.size() < triplesByObject.size()) {
                        return triplesByPredicate.keyStream().filter(t2 -> tripleMatch.getObject().equals(t2.getObject()));
                    }
                }
                return triplesByObject.keyStream().filter(t2 -> tripleMatch.getPredicate().equals(t2.getPredicate()));
            }
            case ANY_PRE_ANY: {
                FastTripleBunch triples = (FastTripleBunch)this.predicates.get(tripleMatch.getPredicate());
                return triples == null ? Stream.empty() : triples.keyStream();
            }
            case ANY_ANY_OBJ: {
                FastTripleBunch triples = (FastTripleBunch)this.objects.get(tripleMatch.getObject());
                return triples == null ? Stream.empty() : triples.keyStream();
            }
            case ANY_ANY_ANY: {
                return this.stream();
            }
        }
        throw new IllegalStateException("Unexpected value: " + PatternClassifier.classify(tripleMatch));
    }

    @Override
    public ExtendedIterator<Triple> find(Triple tripleMatch) {
        switch (PatternClassifier.classify(tripleMatch)) {
            case SUB_PRE_OBJ: {
                FastTripleBunch triples = (FastTripleBunch)this.subjects.get(tripleMatch.getSubject());
                if (triples == null) {
                    return NiceIterator.emptyIterator();
                }
                return triples.containsKey(tripleMatch) ? new SingletonIterator<Triple>(tripleMatch) : NiceIterator.emptyIterator();
            }
            case SUB_PRE_ANY: {
                FastTripleBunch triplesBySubject = (FastTripleBunch)this.subjects.get(tripleMatch.getSubject());
                if (triplesBySubject == null) {
                    return NiceIterator.emptyIterator();
                }
                return triplesBySubject.keyIterator().filterKeep(t2 -> tripleMatch.getPredicate().equals(t2.getPredicate()));
            }
            case SUB_ANY_OBJ: {
                FastTripleBunch triplesBySubject = (FastTripleBunch)this.subjects.get(tripleMatch.getSubject());
                if (triplesBySubject == null) {
                    return NiceIterator.emptyIterator();
                }
                return triplesBySubject.keyIterator().filterKeep(t2 -> tripleMatch.getObject().equals(t2.getObject()));
            }
            case SUB_ANY_ANY: {
                FastTripleBunch triples = (FastTripleBunch)this.subjects.get(tripleMatch.getSubject());
                return triples == null ? NiceIterator.emptyIterator() : triples.keyIterator();
            }
            case ANY_PRE_OBJ: {
                FastTripleBunch triplesByObject = (FastTripleBunch)this.objects.get(tripleMatch.getObject());
                if (triplesByObject == null) {
                    return NiceIterator.emptyIterator();
                }
                if (triplesByObject.size() > 400) {
                    FastTripleBunch triplesByPredicate = (FastTripleBunch)this.predicates.get(tripleMatch.getPredicate());
                    if (triplesByPredicate == null) {
                        return NiceIterator.emptyIterator();
                    }
                    if (triplesByPredicate.size() < triplesByObject.size()) {
                        return triplesByPredicate.keyIterator().filterKeep(t2 -> tripleMatch.getObject().equals(t2.getObject()));
                    }
                }
                return triplesByObject.keyIterator().filterKeep(t2 -> tripleMatch.getPredicate().equals(t2.getPredicate()));
            }
            case ANY_PRE_ANY: {
                FastTripleBunch triples = (FastTripleBunch)this.predicates.get(tripleMatch.getPredicate());
                return triples == null ? NiceIterator.emptyIterator() : triples.keyIterator();
            }
            case ANY_ANY_OBJ: {
                FastTripleBunch triples = (FastTripleBunch)this.objects.get(tripleMatch.getObject());
                return triples == null ? NiceIterator.emptyIterator() : triples.keyIterator();
            }
            case ANY_ANY_ANY: {
                return new IteratorOfJenaSets<Triple>(this.subjects.valueIterator());
            }
        }
        throw new IllegalStateException("Unexpected value: " + PatternClassifier.classify(tripleMatch));
    }

    @Override
    public FastTripleStore copy() {
        return new FastTripleStore(this);
    }

    protected static class ArrayBunchWithSameSubject
    extends FastArrayBunch {
        public ArrayBunchWithSameSubject() {
        }

        private ArrayBunchWithSameSubject(ArrayBunchWithSameSubject bunchToCopy) {
            super(bunchToCopy);
        }

        @Override
        public ArrayBunchWithSameSubject copy() {
            return new ArrayBunchWithSameSubject(this);
        }

        @Override
        public boolean areEqual(Triple a, Triple b) {
            return a.getPredicate().equals(b.getPredicate()) && a.getObject().equals(b.getObject());
        }
    }

    protected static class ArrayBunchWithSameObject
    extends FastArrayBunch {
        public ArrayBunchWithSameObject() {
        }

        private ArrayBunchWithSameObject(ArrayBunchWithSameObject bunchToCopy) {
            super(bunchToCopy);
        }

        @Override
        public ArrayBunchWithSameObject copy() {
            return new ArrayBunchWithSameObject(this);
        }

        @Override
        public boolean areEqual(Triple a, Triple b) {
            return a.getSubject().equals(b.getSubject()) && a.getPredicate().equals(b.getPredicate());
        }
    }

    protected static class ArrayBunchWithSamePredicate
    extends FastArrayBunch {
        public ArrayBunchWithSamePredicate() {
        }

        private ArrayBunchWithSamePredicate(ArrayBunchWithSamePredicate bunchToCopy) {
            super(bunchToCopy);
        }

        @Override
        public ArrayBunchWithSamePredicate copy() {
            return new ArrayBunchWithSamePredicate(this);
        }

        @Override
        public boolean areEqual(Triple a, Triple b) {
            return a.getSubject().equals(b.getSubject()) && a.getObject().equals(b.getObject());
        }
    }
}

