/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.webapp;

import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.webapp.FusekiWebapp;
import org.apache.jena.query.Dataset;
import org.apache.jena.tdb1.TDB1;
import org.apache.jena.tdb1.TDB1Factory;
import org.apache.jena.tdb1.base.block.FileMode;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.setup.StoreParams;
import org.apache.jena.tdb1.sys.StoreConnection;
import org.apache.jena.tdb1.transaction.DatasetGraphTransaction;

public class SystemState {
    private static String SystemDatabaseLocation;
    public static Location location;
    private static Dataset dataset;
    private static DatasetGraphTransaction dsg;
    private static boolean initialized;
    private static final StoreParams systemDatabaseParams;

    public static Dataset getDataset() {
        SystemState.init();
        return dataset;
    }

    public static DatasetGraphTransaction getDatasetGraph() {
        SystemState.init();
        return dsg;
    }

    private static void init() {
        SystemState.init$();
    }

    public static void init$() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (location == null) {
            location = Location.create(FusekiWebapp.dirSystemDatabase.toString());
        }
        if (!location.isMem()) {
            FileOps.ensureDir(location.getDirectoryPath());
        }
        if (StoreConnection.getExisting(location) != null) {
            Fuseki.serverLog.warn("System database already in the StoreConnection cache");
        }
        StoreConnection.make(location, systemDatabaseParams);
        dataset = TDB1Factory.createDataset(location);
        dsg = (DatasetGraphTransaction)dataset.asDatasetGraph();
        dsg.getContext().set(TDB1.symUnionDefaultGraph, false);
    }

    static {
        dataset = null;
        dsg = null;
        initialized = false;
        systemDatabaseParams = StoreParams.builder().fileMode(FileMode.direct).blockSize(1024).blockReadCacheSize(50).blockWriteCacheSize(20).node2NodeIdCacheSize(500).nodeId2NodeCacheSize(500).nodeMissCacheSize(100).build();
    }
}

