/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.system;

import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.system.StreamRDFLimited;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class GraphLoadUtils {
    public static Model readModel(String uri, int limit) {
        Graph g2 = GraphMemFactory.createGraphMem();
        GraphLoadUtils.readUtil(g2, uri, limit);
        return ModelFactory.createModelForGraph(g2);
    }

    public static void loadModel(Model model, String uri, int limit) {
        Graph g2 = model.getGraph();
        GraphLoadUtils.readUtil(g2, uri, limit);
    }

    public static Graph readGraph(String uri, int limit) {
        Graph g2 = GraphMemFactory.createGraphMem();
        GraphLoadUtils.readUtil(g2, uri, limit);
        return g2;
    }

    public static void loadGraph(Graph g2, String uri, int limit) {
        GraphLoadUtils.readUtil(g2, uri, limit);
    }

    private static void readUtil(Graph graph, String uri, int limit) {
        StreamRDF sink = StreamRDFLib.graph(graph);
        sink = new StreamRDFLimited(sink, limit);
        RDFParser.source(uri).streamManager(Fuseki.webStreamManager).parse(sink);
    }
}

