/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.function.Predicate;
import org.apache.jena.fuseki.Fuseki;

public class AuthFilter
implements Filter {
    private final Predicate<String> predicate;

    public AuthFilter(Predicate<String> allowAccess) {
        this.predicate = allowAccess;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filter) throws IOException, ServletException {
        try {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String user = httpRequest.getRemoteUser();
            boolean allowed = this.predicate.test(user);
            if (!allowed) {
                httpResponse.sendError(403);
                return;
            }
            filter.doFilter(httpRequest, httpResponse);
        }
        catch (ClassCastException ex) {
            Fuseki.actionLog.error(ex.getMessage());
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void destroy() {
    }
}

