/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.enhanced;

import org.apache.jena.enhanced.AlreadyLinkedViewException;
import org.apache.jena.enhanced.Personality;

public abstract class Polymorphic<T> {
    private Polymorphic<T> ring = this;

    Polymorphic() {
    }

    protected abstract Personality<T> getPersonality();

    public <X extends T> boolean supports(Class<X> t2) {
        X supporter = this.findExistingView(t2);
        return supporter != null || this.canSupport(t2);
    }

    protected final <X extends T> X asInternal(Class<X> t2) {
        X other = this.findExistingView(t2);
        return other == null ? this.convertTo(t2) : other;
    }

    private <X extends T> X findExistingView(Class<X> t2) {
        Polymorphic<T> r = this;
        do {
            if (!t2.isInstance(r) || !r.isValid()) continue;
            return t2.cast(r);
        } while ((r = r.ring) != this);
        return null;
    }

    protected <X extends T> boolean alreadyHasView(Class<X> t2) {
        return this.findExistingView(t2) != null;
    }

    public abstract boolean isValid();

    protected abstract <X extends T> X convertTo(Class<X> var1);

    protected abstract <X extends T> boolean canSupport(Class<X> var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public synchronized void addView(Polymorphic<T> other) {
        if (other.ring != other) {
            throw new AlreadyLinkedViewException(other);
        }
        other.ring = this.ring;
        this.ring = other;
    }
}

