/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.common.lang.NonNull;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.prometheus.client.exemplars.CounterExemplarSampler;
import io.prometheus.client.exemplars.Exemplar;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAdder;

public class PrometheusCounter
extends AbstractMeter
implements Counter {
    private final DoubleAdder count = new DoubleAdder();
    private final AtomicReference<Exemplar> exemplar = new AtomicReference();
    @Nullable
    private final CounterExemplarSampler exemplarSampler;

    PrometheusCounter(Meter.Id id) {
        this(id, null);
    }

    PrometheusCounter(Meter.Id id, @Nullable CounterExemplarSampler exemplarSampler) {
        super(id);
        this.exemplarSampler = exemplarSampler;
    }

    @Override
    public void increment(double amount) {
        if (amount > 0.0) {
            this.count.add(amount);
            if (this.exemplarSampler != null) {
                this.updateExemplar(amount, this.exemplarSampler);
            }
        }
    }

    @Override
    public double count() {
        return this.count.doubleValue();
    }

    @Nullable
    Exemplar exemplar() {
        return this.exemplar.get();
    }

    private void updateExemplar(double amount, @NonNull CounterExemplarSampler exemplarSampler) {
        Exemplar prev;
        Exemplar next;
        while ((next = exemplarSampler.sample(amount, prev = this.exemplar.get())) != null && next != prev && !this.exemplar.compareAndSet(prev, next)) {
        }
    }
}

