/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AbstractLinkedDeque;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AccessOrderDeque<E extends AccessOrder<E>>
extends AbstractLinkedDeque<E> {
    AccessOrderDeque() {
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof AccessOrder && this.contains((AccessOrder)o);
    }

    boolean contains(AccessOrder<?> e2) {
        return e2.getPreviousInAccessOrder() != null || e2.getNextInAccessOrder() != null || e2 == this.first;
    }

    @Override
    public boolean remove(Object o) {
        return o instanceof AccessOrder && this.remove((E)((AccessOrder)o));
    }

    @Override
    boolean remove(E e2) {
        if (this.contains((AccessOrder<?>)e2)) {
            this.unlink(e2);
            return true;
        }
        return false;
    }

    @Override
    public @Nullable E getPrevious(E e2) {
        return (E)e2.getPreviousInAccessOrder();
    }

    @Override
    public void setPrevious(E e2, @Nullable E prev) {
        e2.setPreviousInAccessOrder(prev);
    }

    @Override
    public @Nullable E getNext(E e2) {
        return (E)e2.getNextInAccessOrder();
    }

    @Override
    public void setNext(E e2, @Nullable E next) {
        e2.setNextInAccessOrder(next);
    }

    static interface AccessOrder<T extends AccessOrder<T>> {
        public @Nullable T getPreviousInAccessOrder();

        public void setPreviousInAccessOrder(@Nullable T var1);

        public @Nullable T getNextInAccessOrder();

        public void setNextInAccessOrder(@Nullable T var1);
    }
}

