/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.uri;

import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.lang.Keywords;
import java.net.URI;

public final class UriUtils {
    private UriUtils() {
    }

    public static final boolean isURI(String value) {
        return value != null && StringUtils.isNotBlank(value) && !Keywords.matchForm(StringUtils.strip(value)) && UriUtils.create(StringUtils.strip(value)) != null;
    }

    public static final URI create(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("The uri cannot be null.");
        }
        Object uriValue = StringUtils.strip(uri);
        if (((String)uriValue).isEmpty()) {
            return null;
        }
        if (((String)uriValue).endsWith(":")) {
            uriValue = (String)uriValue + ".";
        } else if (((String)uriValue).endsWith("[") || ((String)uriValue).endsWith("]")) {
            uriValue = ((String)uriValue).substring(0, ((String)uriValue).length() - 1);
        }
        try {
            return URI.create((String)uriValue);
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
    }

    public static final boolean endsWithGenDelim(String uri) {
        return uri.endsWith(":") || uri.endsWith("/") || uri.endsWith("?") || uri.endsWith("#") || uri.endsWith("[") || uri.endsWith("]") || uri.endsWith("@");
    }

    public static final boolean isNotURI(String uri) {
        return uri == null || StringUtils.isBlank(uri) || Keywords.matchForm(StringUtils.strip(uri)) || UriUtils.create(StringUtils.strip(uri)) == null;
    }

    @Deprecated
    public static final boolean isNotAbsoluteUri(String uri) {
        return UriUtils.isNotAbsoluteUri(uri, true);
    }

    public static final boolean isNotAbsoluteUri(String uri, boolean validate) {
        return !UriUtils.isAbsoluteUri(uri, validate);
    }

    @Deprecated
    public static final boolean isAbsoluteUri(String uri) {
        return UriUtils.isAbsoluteUri(uri, true);
    }

    public static final boolean isAbsoluteUri(String uri, boolean validate) {
        if (!validate) {
            return UriUtils.startsWithScheme(uri);
        }
        if (uri == null || uri.length() < 3) {
            return false;
        }
        try {
            return URI.create(uri).isAbsolute();
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    private static final boolean startsWithScheme(String uri) {
        if (uri == null || uri.length() < 2 || !Character.isLetter(uri.codePointAt(0))) {
            return false;
        }
        for (int i = 1; i < uri.length(); ++i) {
            if (Character.isLetterOrDigit(uri.codePointAt(i)) || uri.charAt(i) == '-' || uri.charAt(i) == '+' || uri.charAt(i) == '.') continue;
            return uri.charAt(i) == ':';
        }
        return false;
    }

    protected static final String recompose(String scheme, String authority, String path, String query2, String fragment) {
        StringBuilder builder = new StringBuilder();
        if (scheme != null) {
            builder.append(scheme);
            builder.append(":");
        }
        if (authority != null) {
            builder.append("//");
            builder.append(authority);
        }
        if (path != null) {
            builder.append(path);
        }
        if (query2 != null) {
            builder.append('?');
            builder.append(query2);
        }
        if (fragment != null) {
            builder.append('#');
            builder.append(fragment);
        }
        return builder.toString();
    }
}

