/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.cmd.ModBase;
import org.apache.jena.query.Query;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.util.QueryOutputUtils;

public class ModQueryOut
extends ModBase {
    protected final ArgDecl queryOutputSyntaxDecl = new ArgDecl(true, "out", "format");
    protected final ArgDecl queryNumberDecl = new ArgDecl(false, "num", "number");
    private Syntax outputSyntax = Syntax.syntaxSPARQL;
    private boolean lineNumbers = false;

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Output");
        cmdLine.add(this.queryOutputSyntaxDecl, "--out, --format", "Output syntax");
        cmdLine.add(this.queryNumberDecl, "--num", "Print line numbers");
    }

    @Override
    public void processArgs(CmdArgModule cmdline) throws IllegalArgumentException {
        if (cmdline.contains(this.queryOutputSyntaxDecl)) {
            String s2 = cmdline.getValue(this.queryOutputSyntaxDecl);
            Syntax syn = Syntax.lookup(s2);
            if (syn == null) {
                cmdline.cmdError("Unrecognized syntax: " + s2);
            }
            this.outputSyntax = syn;
        }
        this.lineNumbers = cmdline.contains(this.queryNumberDecl);
    }

    public Syntax getOutputSyntax() {
        return this.outputSyntax;
    }

    public void output(Query query2) {
        this.output(this.out(), query2);
    }

    public void output(IndentedWriter out, Query query2) {
        QueryOutputUtils.printQuery(out, query2, this.outputSyntax);
    }

    public void outputOp(Query query2, boolean printOptimized) {
        this.outputOp(this.out(), query2, printOptimized);
    }

    public void outputOp(IndentedWriter out, Query query2, boolean printOptimized) {
        QueryOutputUtils.printOp(out, query2, printOptimized);
    }

    public void outputQuad(Query query2, boolean printOptimized) {
        this.outputQuad(this.out(), query2, printOptimized);
    }

    public void outputQuad(IndentedWriter out, Query query2, boolean printOptimized) {
        QueryOutputUtils.printQuad(out, query2, printOptimized);
    }

    private IndentedWriter out() {
        return new IndentedWriter(System.out, this.lineNumbers);
    }
}

