/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.tdb1.TDB1;
import org.apache.jena.tdb1.TDB1Loader;
import org.apache.jena.tdb1.store.GraphTDB;
import org.apache.jena.util.FileUtils;
import tdb.cmdline.CmdTDB;
import tdb.cmdline.CmdTDBGraph;

public class tdbloader
extends CmdTDBGraph {
    private static final ArgDecl argNoStats = new ArgDecl(false, "nostats");
    private static final ArgDecl argStats = new ArgDecl(true, "stats");
    private static final ArgDecl argSyntax = new ArgDecl(true, "syntax");
    private boolean showProgress = true;
    private boolean generateStats = true;
    private Lang lang = null;

    public static void main(String ... argv) {
        CmdTDB.init();
        TDB1.setOptimizerWarningFlag(false);
        new tdbloader(argv).mainRun();
    }

    protected tdbloader(String[] argv) {
        super(argv);
        super.add(argNoStats, "--nostats", "Switch off statistics gathering");
        super.add(argSyntax, "--syntax=LANG", "Syntax of data from stdin");
        super.add(argStats);
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (super.contains(argSyntax)) {
            String syntax = super.getValue(argSyntax);
            Lang lang$ = RDFLanguages.nameToLang(syntax);
            if (lang$ == null) {
                throw new CmdException("Can not detemine the syntax from '" + syntax + "'");
            }
            this.lang = lang$;
        }
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " [--desc DATASET | -loc DIR] FILE ...";
    }

    @Override
    protected void exec() {
        List<String> urls;
        if (this.isVerbose()) {
            System.out.println("Java maximum memory: " + Runtime.getRuntime().maxMemory());
            System.out.println(ARQ.getContext());
        }
        if (this.isVerbose()) {
            this.showProgress = true;
        }
        if (this.isQuiet()) {
            this.showProgress = false;
        }
        if (super.contains(argStats)) {
            if (!this.hasValueOfTrue(argStats) && !this.hasValueOfFalse(argStats)) {
                throw new CmdException("Not a boolean value: " + this.getValue(argStats));
            }
            this.generateStats = super.hasValueOfTrue(argStats);
        }
        if (super.contains(argNoStats)) {
            this.generateStats = false;
        }
        if ((urls = this.getPositional()).size() != 0) {
            this.checkFiles(urls);
        }
        if (this.graphName == null) {
            if (urls.size() == 0) {
                this.checkFiles(urls);
                this.loadQuadsStdin();
            } else {
                this.loadQuads(urls);
            }
            return;
        }
        for (String url : urls) {
            Lang lang = RDFLanguages.filenameToLang(url);
            if (lang == null || !RDFLanguages.isQuads(lang)) continue;
            throw new CmdException("Warning: Quads format given - only the default graph is loaded into the graph for --graph");
        }
        this.loadNamedGraph(urls);
    }

    private void checkFiles(List<String> urls) {
        List<String> problemFiles = ListUtils.toList(urls.stream().filter(u -> FileUtils.isFile(u)).map(x$0 -> Paths.get(x$0, new String[0])).filter(p -> !Files.exists(p, new LinkOption[0]) || !Files.isRegularFile(p, new LinkOption[0]) || !Files.isReadable(p)).map(Path::toString));
        if (!problemFiles.isEmpty()) {
            String str2 = String.join((CharSequence)", ", problemFiles);
            throw new CmdException("Can't read files : " + str2);
        }
    }

    void loadNamedGraph(List<String> urls) {
        GraphTDB graph = this.getGraph();
        TDB1Loader.load(graph, urls, this.showProgress);
    }

    void loadQuads(List<String> urls) {
        TDB1Loader.load(this.getDatasetGraphTDB(), urls, this.showProgress, this.generateStats);
    }

    private void loadQuadsStdin() {
        TDB1Loader.load(this.getDatasetGraphTDB(), System.in, this.lang, this.showProgress, this.generateStats);
    }
}

