/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import jakarta.json.JsonMergePatch;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import org.glassfish.json.JsonObjectBuilderImpl;
import org.glassfish.json.JsonUtil;

public final class JsonMergePatchImpl
implements JsonMergePatch {
    private JsonValue patch;

    public JsonMergePatchImpl(JsonValue patch) {
        this.patch = patch;
    }

    @Override
    public JsonValue apply(JsonValue target) {
        return JsonMergePatchImpl.mergePatch(target, this.patch);
    }

    @Override
    public JsonValue toJsonValue() {
        return this.patch;
    }

    private static JsonValue mergePatch(JsonValue target, JsonValue patch) {
        if (patch.getValueType() != JsonValue.ValueType.OBJECT) {
            return patch;
        }
        if (target.getValueType() != JsonValue.ValueType.OBJECT) {
            target = JsonValue.EMPTY_JSON_OBJECT;
        }
        JsonObject targetJsonObject = target.asJsonObject();
        JsonObjectBuilderImpl builder = new JsonObjectBuilderImpl(targetJsonObject, JsonUtil.getInternalBufferPool());
        patch.asJsonObject().forEach((key, value) -> {
            if (value == JsonValue.NULL) {
                if (targetJsonObject.containsKey(key)) {
                    builder.remove((String)key);
                }
            } else if (targetJsonObject.containsKey(key)) {
                builder.add((String)key, JsonMergePatchImpl.mergePatch((JsonValue)targetJsonObject.get(key), value));
            } else {
                builder.add((String)key, JsonMergePatchImpl.mergePatch(JsonValue.EMPTY_JSON_OBJECT, value));
            }
        });
        return builder.build();
    }

    static JsonValue diff(JsonValue source, JsonValue target) {
        if (source.getValueType() != JsonValue.ValueType.OBJECT || target.getValueType() != JsonValue.ValueType.OBJECT) {
            return target;
        }
        JsonObject s2 = (JsonObject)source;
        JsonObject t2 = (JsonObject)target;
        JsonObjectBuilderImpl builder = new JsonObjectBuilderImpl(JsonUtil.getInternalBufferPool());
        s2.forEach((key, value) -> {
            if (t2.containsKey(key)) {
                if (!value.equals(t2.get(key))) {
                    builder.add((String)key, JsonMergePatchImpl.diff(value, (JsonValue)t2.get(key)));
                }
            } else {
                builder.addNull((String)key);
            }
        });
        t2.forEach((key, value) -> {
            if (!s2.containsKey(key)) {
                builder.add((String)key, (JsonValue)value);
            }
        });
        return builder.build();
    }
}

