/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.thread.Invocable;

public interface Callback
extends Invocable {
    public static final Callback NOOP = new Callback(){

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }

        public String toString() {
            return "Callback.NOOP";
        }
    };

    default public void completeWith(CompletableFuture<?> completable) {
        completable.whenComplete((o, x) -> {
            if (x == null) {
                this.succeeded();
            } else {
                this.failed((Throwable)x);
            }
        });
    }

    default public void succeeded() {
    }

    default public void failed(Throwable x) {
    }

    public static Callback from(CompletableFuture<?> completable) {
        return Callback.from(completable, Invocable.InvocationType.NON_BLOCKING);
    }

    public static Callback from(final CompletableFuture<?> completable, final Invocable.InvocationType invocation) {
        if (completable instanceof Callback) {
            return (Callback)((Object)completable);
        }
        return new Callback(){

            @Override
            public void succeeded() {
                completable.complete(null);
            }

            @Override
            public void failed(Throwable x) {
                completable.completeExceptionally(x);
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return invocation;
            }
        };
    }

    public static Callback from(Runnable success, Consumer<Throwable> failure) {
        return Callback.from(Invocable.InvocationType.BLOCKING, success, failure);
    }

    public static Callback from(final Invocable.InvocationType invocationType, final Runnable success, final Consumer<Throwable> failure) {
        return new Callback(){

            @Override
            public void succeeded() {
                success.run();
            }

            @Override
            public void failed(Throwable x) {
                failure.accept(x);
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return invocationType;
            }

            public String toString() {
                return "Callback@%x{%s, %s,%s}".formatted(new Object[]{this.hashCode(), invocationType, success, failure});
            }
        };
    }

    public static Callback from(Runnable completed) {
        return Callback.from(Invocable.getInvocationType(completed), completed);
    }

    public static Callback from(final Invocable.InvocationType invocationType, final Runnable completed) {
        return new Completing(){

            @Override
            public void completed() {
                completed.run();
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return invocationType;
            }

            public String toString() {
                return "Callback.Completing@%x{%s,%s}".formatted(new Object[]{this.hashCode(), invocationType, completed});
            }
        };
    }

    public static Callback from(Callback callback, final Runnable completed) {
        return new Nested(callback){

            @Override
            public void completed() {
                completed.run();
            }
        };
    }

    public static Callback from(final Callback callback, final Consumer<Throwable> completed) {
        return new Callback(){

            @Override
            public void succeeded() {
                try {
                    callback.succeeded();
                }
                finally {
                    completed.accept(null);
                }
            }

            @Override
            public void failed(Throwable x) {
                try {
                    callback.failed(x);
                }
                finally {
                    completed.accept(x);
                }
            }
        };
    }

    public static Callback from(final Runnable completed, final Callback callback) {
        return new Callback(){

            @Override
            public void succeeded() {
                try {
                    completed.run();
                    callback.succeeded();
                }
                catch (Throwable t2) {
                    callback.failed(t2);
                }
            }

            @Override
            public void failed(Throwable x) {
                try {
                    completed.run();
                }
                catch (Throwable t2) {
                    x.addSuppressed(t2);
                }
                callback.failed(x);
            }
        };
    }

    public static Callback from(final Callback callback, final Throwable cause) {
        return new Callback(){

            @Override
            public void succeeded() {
                callback.failed(cause);
            }

            @Override
            public void failed(Throwable x) {
                cause.addSuppressed(x);
                callback.failed(cause);
            }
        };
    }

    public static Callback from(Callback callback1, Callback callback2) {
        return Callback.combine(callback1, callback2);
    }

    public static Callback combine(final Callback cb1, final Callback cb2) {
        if (cb1 == null || cb1 == cb2) {
            return cb2;
        }
        if (cb2 == null) {
            return cb1;
        }
        return new Callback(){

            @Override
            public void succeeded() {
                try {
                    cb1.succeeded();
                }
                finally {
                    cb2.succeeded();
                }
            }

            @Override
            public void failed(Throwable x) {
                try {
                    cb1.failed(x);
                }
                catch (Throwable t2) {
                    ExceptionUtil.addSuppressedIfNotAssociated(x, t2);
                }
                finally {
                    cb2.failed(x);
                }
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.combine(Invocable.getInvocationType(cb1), Invocable.getInvocationType(cb2));
            }
        };
    }

    public static class Completable
    extends CompletableFuture<Void>
    implements Callback {
        private final Invocable.InvocationType invocation;

        public static Completable with(Consumer<Completable> consumer) {
            Completable completable = new Completable();
            consumer.accept(completable);
            return completable;
        }

        public static Completable from(final Callback callback) {
            return new Completable(callback.getInvocationType()){

                @Override
                public void succeeded() {
                    callback.succeeded();
                    super.succeeded();
                }

                @Override
                public void failed(Throwable x) {
                    callback.failed(x);
                    super.failed(x);
                }
            };
        }

        public Completable() {
            this(Invocable.InvocationType.NON_BLOCKING);
        }

        public Completable(Invocable.InvocationType invocation) {
            this.invocation = invocation;
        }

        @Override
        public void succeeded() {
            this.complete(null);
        }

        @Override
        public void failed(Throwable x) {
            this.completeExceptionally(x);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this.invocation;
        }

        public Completable compose(Consumer<Completable> consumer) {
            Completable completable = new Completable();
            this.whenComplete((T r, U x) -> {
                if (x == null) {
                    consumer.accept(completable);
                } else {
                    completable.failed((Throwable)x);
                }
            });
            return completable;
        }
    }

    public static class Nested
    implements Completing {
        private final Callback callback;

        public Nested(Callback callback) {
            this.callback = Objects.requireNonNull(callback);
        }

        public Callback getCallback() {
            return this.callback;
        }

        @Override
        public void completed() {
        }

        @Override
        public void succeeded() {
            try {
                this.callback.succeeded();
            }
            finally {
                this.completed();
            }
        }

        @Override
        public void failed(Throwable x) {
            try {
                this.callback.failed(x);
            }
            finally {
                this.completed();
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this.callback.getInvocationType();
        }

        public String toString() {
            return "%s@%x:%s".formatted(this.getClass().getSimpleName(), this.hashCode(), this.callback);
        }
    }

    public static interface Completing
    extends Callback {
        public void completed();

        @Override
        default public void succeeded() {
            this.completed();
        }

        @Override
        default public void failed(Throwable x) {
            this.completed();
        }
    }
}

