/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.CountingCallback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.Graceful;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulHandler
extends Handler.Wrapper
implements Graceful {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulHandler.class);
    private final LongAdder _requests = new LongAdder();
    private final Graceful.Shutdown _shutdown = new Graceful.Shutdown(this){

        @Override
        public boolean isShutdownDone() {
            long count = GracefulHandler.this.getCurrentRequestCount();
            if (LOG.isDebugEnabled()) {
                LOG.debug("isShutdownDone: count {}", (Object)count);
            }
            return count == 0L;
        }
    };

    public GracefulHandler() {
        this((Handler)null);
    }

    public GracefulHandler(Handler handler) {
        super(handler);
    }

    @ManagedAttribute(value="number of requests being currently handled")
    public long getCurrentRequestCount() {
        return this._requests.sum();
    }

    @Override
    public boolean isShutdown() {
        return this._shutdown.isShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Handler handler = this.getHandler();
        if (handler == null || !this.isStarted()) {
            return false;
        }
        ShutdownTrackingCallback shutdownCallback = new ShutdownTrackingCallback(request, response, callback);
        if (this.isShutdown()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Service Unavailable: {}", (Object)request.getHttpURI());
            }
            Response.writeError(request, response, (Callback)shutdownCallback, 503);
            return true;
        }
        try {
            boolean handled = super.handle(request, response, shutdownCallback);
            if (!handled) {
                shutdownCallback.completed();
            }
            boolean bl = handled;
            return bl;
        }
        catch (Throwable t2) {
            Response.writeError(request, response, (Callback)shutdownCallback, t2);
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.isShutdown()) {
                this._shutdown.check();
            }
        }
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutdown requested");
        }
        return this._shutdown.shutdown();
    }

    private class ShutdownTrackingCallback
    extends CountingCallback {
        final Request request;
        final Response response;

        public ShutdownTrackingCallback(Request request, Response response, Callback callback) {
            super(callback, 1);
            this.request = request;
            this.response = response;
            GracefulHandler.this._requests.increment();
        }

        @Override
        public void completed() {
            GracefulHandler.this._requests.decrement();
            if (GracefulHandler.this.isShutdown()) {
                GracefulHandler.this._shutdown.check();
            }
        }
    }
}

