/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.tags;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import org.apache.shiro.web.tags.SecureTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalTag
extends SecureTag {
    private static final Logger log = LoggerFactory.getLogger(PrincipalTag.class);
    private String type;
    private String property;
    private String defaultValue;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public int onDoStartTag() throws JspException {
        Object principal;
        String strValue = null;
        if (this.getSubject() != null && (principal = this.type == null ? this.getSubject().getPrincipal() : this.getPrincipalFromClassName()) != null) {
            strValue = this.property == null ? principal.toString() : this.getPrincipalProperty(principal, this.property);
        }
        if (strValue != null) {
            try {
                this.pageContext.getOut().write(strValue);
            }
            catch (IOException e2) {
                throw new JspTagException("Error writing [" + strValue + "] to JSP.", (Throwable)e2);
            }
        }
        return 0;
    }

    private Object getPrincipalFromClassName() {
        Object principal;
        block2: {
            principal = null;
            try {
                Class<?> cls = Class.forName(this.type);
                principal = this.getSubject().getPrincipals().oneByType(cls);
            }
            catch (ClassNotFoundException e2) {
                if (!log.isErrorEnabled()) break block2;
                log.error("Unable to find class for name [" + this.type + "]");
            }
        }
        return principal;
    }

    private String getPrincipalProperty(Object principal, String property) throws JspTagException {
        String strValue = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(principal.getClass());
            boolean foundProperty = false;
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                if (!pd.getName().equals(property)) continue;
                Object value = pd.getReadMethod().invoke(principal, (Object[])null);
                strValue = String.valueOf(value);
                foundProperty = true;
                break;
            }
            if (!foundProperty) {
                String message = "Property [" + property + "] not found in principal of type [" + principal.getClass().getName() + "]";
                if (log.isErrorEnabled()) {
                    log.error(message);
                }
                throw new JspTagException(message);
            }
        }
        catch (Exception e2) {
            String message = "Error reading property [" + property + "] from principal of type [" + principal.getClass().getName() + "]";
            if (log.isErrorEnabled()) {
                log.error(message, e2);
            }
            throw new JspTagException(message, (Throwable)e2);
        }
        return strValue;
    }
}

