/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.web.servlet.HttpSessionContext;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.session.HttpServletSession;

public class ShiroHttpSession
implements HttpSession {
    public static final String DEFAULT_SESSION_ID_NAME = "JSESSIONID";
    private static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };
    private static final HttpSessionContext HTTP_SESSION_CONTEXT = new HttpSessionContext(){

        public HttpSession getSession(String s2) {
            return null;
        }

        public Enumeration getIds() {
            return EMPTY_ENUMERATION;
        }
    };
    protected ServletContext servletContext = null;
    protected HttpServletRequest currentRequest = null;
    protected Session session = null;

    public ShiroHttpSession(Session session, HttpServletRequest currentRequest, ServletContext servletContext) {
        if (session instanceof HttpServletSession) {
            String msg = "Session constructor argument cannot be an instance of HttpServletSession.  This is enforced to prevent circular dependencies and infinite loops.";
            throw new IllegalArgumentException(msg);
        }
        this.session = session;
        this.currentRequest = currentRequest;
        this.servletContext = servletContext;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public long getCreationTime() {
        try {
            return this.getSession().getStartTimestamp().getTime();
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public String getId() {
        return this.getSession().getId().toString();
    }

    @Override
    public long getLastAccessedTime() {
        return this.getSession().getLastAccessTime().getTime();
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setMaxInactiveInterval(int i) {
        try {
            this.getSession().setTimeout((long)i * 1000L);
        }
        catch (InvalidSessionException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public int getMaxInactiveInterval() {
        try {
            return new Long(this.getSession().getTimeout() / 1000L).intValue();
        }
        catch (InvalidSessionException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public HttpSessionContext getSessionContext() {
        return HTTP_SESSION_CONTEXT;
    }

    @Override
    public Object getAttribute(String s2) {
        try {
            return this.getSession().getAttribute(s2);
        }
        catch (InvalidSessionException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public Object getValue(String s2) {
        return this.getAttribute(s2);
    }

    protected Set<String> getKeyNames() {
        HashSet<String> keyNames;
        Collection<Object> keySet;
        try {
            keySet = this.getSession().getAttributeKeys();
        }
        catch (InvalidSessionException e2) {
            throw new IllegalStateException(e2);
        }
        if (keySet != null && !keySet.isEmpty()) {
            keyNames = new HashSet<String>(keySet.size());
            for (Object o : keySet) {
                keyNames.add(o.toString());
            }
        } else {
            keyNames = Collections.EMPTY_SET;
        }
        return keyNames;
    }

    public Enumeration getAttributeNames() {
        Set<String> keyNames = this.getKeyNames();
        final Iterator<String> iterator = keyNames.iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    public String[] getValueNames() {
        Set<String> keyNames = this.getKeyNames();
        String[] array = new String[keyNames.size()];
        if (keyNames.size() > 0) {
            array = keyNames.toArray(array);
        }
        return array;
    }

    protected void afterBound(String s2, Object o) {
        if (o instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)o;
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, s2, o);
            listener.valueBound(event);
        }
    }

    protected void afterUnbound(String s2, Object o) {
        if (o instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)o;
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, s2, o);
            listener.valueUnbound(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String s2, Object o) {
        try {
            this.getSession().setAttribute(s2, o);
            this.afterBound(s2, o);
        }
        catch (InvalidSessionException e2) {
            try {
                this.afterUnbound(s2, o);
            }
            finally {
                throw new IllegalStateException(e2);
            }
        }
    }

    public void putValue(String s2, Object o) {
        this.setAttribute(s2, o);
    }

    @Override
    public void removeAttribute(String s2) {
        try {
            Object attribute = this.getSession().removeAttribute(s2);
            this.afterUnbound(s2, attribute);
        }
        catch (InvalidSessionException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public void removeValue(String s2) {
        this.removeAttribute(s2);
    }

    @Override
    public void invalidate() {
        try {
            this.getSession().stop();
        }
        catch (InvalidSessionException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public boolean isNew() {
        Boolean value = (Boolean)this.currentRequest.getAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_IS_NEW);
        return value != null && value.equals(Boolean.TRUE);
    }
}

