/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import org.apache.shiro.crypto.JcaCipherService;

public abstract class AbstractSymmetricCipherService
extends JcaCipherService {
    protected AbstractSymmetricCipherService(String algorithmName) {
        super(algorithmName);
    }

    public Key generateNewKey() {
        return this.generateNewKey(this.getKeySize());
    }

    public Key generateNewKey(int keyBitSize) {
        KeyGenerator kg2;
        try {
            kg2 = KeyGenerator.getInstance(this.getAlgorithmName());
        }
        catch (NoSuchAlgorithmException e2) {
            String msg = "Unable to acquire " + this.getAlgorithmName() + " algorithm.  This is required to function.";
            throw new IllegalStateException(msg, e2);
        }
        kg2.init(keyBitSize);
        return kg2.generateKey();
    }
}

