/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.AbstractKnnVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;

public class KnnByteVectorQuery
extends AbstractKnnVectorQuery {
    private static final TopDocs NO_RESULTS = TopDocsCollector.EMPTY_TOPDOCS;
    private final byte[] target;

    public KnnByteVectorQuery(String field, byte[] target, int k) {
        this(field, target, k, null);
    }

    public KnnByteVectorQuery(String field, byte[] target, int k, Query filter) {
        super(field, k, filter);
        this.target = Objects.requireNonNull(target, "target");
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context2, Bits acceptDocs, int visitedLimit) throws IOException {
        TopDocs results = context2.reader().searchNearestVectors(this.field, this.target, this.k, acceptDocs, visitedLimit);
        return results != null ? results : NO_RESULTS;
    }

    @Override
    VectorScorer createVectorScorer(LeafReaderContext context2, FieldInfo fi) throws IOException {
        if (fi.getVectorEncoding() != VectorEncoding.BYTE) {
            return null;
        }
        return VectorScorer.create(context2, fi, this.target);
    }

    @Override
    public String toString(String field) {
        return this.getClass().getSimpleName() + ":" + this.field + "[" + this.target[0] + ",...][" + this.k + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        KnnByteVectorQuery that = (KnnByteVectorQuery)o;
        return Arrays.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.target));
    }

    public byte[] getTargetCopy() {
        return ArrayUtil.copyOfSubArray(this.target, 0, this.target.length);
    }
}

