/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene99;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.codecs.lucene99.QuantizedByteVectorValues;
import org.apache.lucene.codecs.lucene99.RandomAccessQuantizedByteVectorValues;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.packed.DirectMonotonicReader;

abstract class OffHeapQuantizedByteVectorValues
extends QuantizedByteVectorValues
implements RandomAccessQuantizedByteVectorValues {
    protected final int dimension;
    protected final int size;
    protected final IndexInput slice;
    protected final byte[] binaryValue;
    protected final ByteBuffer byteBuffer;
    protected final int byteSize;
    protected int lastOrd = -1;
    protected final float[] scoreCorrectionConstant = new float[1];

    OffHeapQuantizedByteVectorValues(int dimension, int size, IndexInput slice) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.byteSize = dimension + 4;
        this.byteBuffer = ByteBuffer.allocate(dimension);
        this.binaryValue = this.byteBuffer.array();
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.binaryValue;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.dimension);
        this.slice.readFloats(this.scoreCorrectionConstant, 0, 1);
        this.lastOrd = targetOrd;
        return this.binaryValue;
    }

    @Override
    public float getScoreCorrectionConstant() {
        return this.scoreCorrectionConstant[0];
    }

    static OffHeapQuantizedByteVectorValues load(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, long quantizedVectorDataOffset, long quantizedVectorDataLength, IndexInput vectorData) throws IOException {
        if (configuration.isEmpty()) {
            return new EmptyOffHeapVectorValues(dimension);
        }
        IndexInput bytesSlice = vectorData.slice("quantized-vector-data", quantizedVectorDataOffset, quantizedVectorDataLength);
        if (configuration.isDense()) {
            return new DenseOffHeapVectorValues(dimension, size, bytesSlice);
        }
        return new SparseOffHeapVectorValues(configuration, dimension, size, vectorData, bytesSlice);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapQuantizedByteVectorValues {
        private int doc = -1;

        public EmptyOffHeapVectorValues(int dimension) {
            super(dimension, 0, null);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public byte[] vectorValue() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public EmptyOffHeapVectorValues copy() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] vectorValue(int targetOrd) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int ordToDoc(int ord) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapQuantizedByteVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final OrdToDocDISIReaderConfiguration configuration;

        public SparseOffHeapVectorValues(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, IndexInput dataIn, IndexInput slice) throws IOException {
            super(dimension, size, slice);
            this.configuration = configuration;
            this.dataIn = dataIn;
            this.ordToDoc = configuration.getDirectMonotonicReader(dataIn);
            this.disi = configuration.getIndexedDISI(dataIn);
        }

        @Override
        public byte[] vectorValue() throws IOException {
            return this.vectorValue(this.disi.index());
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            assert (this.docID() < target);
            return this.disi.advance(target);
        }

        @Override
        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.configuration, this.dimension, this.size, this.dataIn, this.slice.clone());
        }

        @Override
        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get(ord);
        }

        @Override
        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                @Override
                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                @Override
                public int length() {
                    return size;
                }
            };
        }
    }

    static class DenseOffHeapVectorValues
    extends OffHeapQuantizedByteVectorValues {
        private int doc = -1;

        public DenseOffHeapVectorValues(int dimension, int size, IndexInput slice) {
            super(dimension, size, slice);
        }

        @Override
        public byte[] vectorValue() throws IOException {
            return this.vectorValue(this.doc);
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            assert (this.docID() < target);
            if (target >= this.size) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.slice.clone());
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }
    }
}

