/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.analysis.hunspell.AffixCondition;
import org.apache.lucene.analysis.hunspell.AffixKind;
import org.apache.lucene.analysis.hunspell.AffixedWord;
import org.apache.lucene.analysis.hunspell.DictEntries;
import org.apache.lucene.analysis.hunspell.DictEntry;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.EntrySuggestion;
import org.apache.lucene.analysis.hunspell.FlagEnumerator;
import org.apache.lucene.analysis.hunspell.Stemmer;
import org.apache.lucene.analysis.hunspell.WordContext;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.IntsRefFSTEnum;

public class WordFormGenerator {
    private final Dictionary dictionary;
    private final Map<Character, List<AffixEntry>> affixes = new HashMap<Character, List<AffixEntry>>();
    private final Stemmer stemmer;

    public WordFormGenerator(Dictionary dictionary) {
        this.dictionary = dictionary;
        this.fillAffixMap(dictionary.prefixes, AffixKind.PREFIX);
        this.fillAffixMap(dictionary.suffixes, AffixKind.SUFFIX);
        this.stemmer = new Stemmer(dictionary);
    }

    private void fillAffixMap(FST<IntsRef> fst, AffixKind kind) {
        if (fst == null) {
            return;
        }
        IntsRefFSTEnum<IntsRef> fstEnum = new IntsRefFSTEnum<IntsRef>(fst);
        try {
            IntsRefFSTEnum.InputOutput<IntsRef> io;
            while ((io = fstEnum.next()) != null) {
                IntsRef affixIds = (IntsRef)io.output;
                for (int j = 0; j < affixIds.length; ++j) {
                    int id = affixIds.ints[affixIds.offset + j];
                    char flag = this.dictionary.affixData(id, 0);
                    AffixEntry entry = new AffixEntry(id, flag, kind, this.toString(kind, io.input), this.strip(id), this.condition(id));
                    this.affixes.computeIfAbsent(Character.valueOf(flag), __ -> new ArrayList()).add(entry);
                }
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private String toString(AffixKind kind, IntsRef input) {
        char[] affixChars = new char[input.length];
        for (int i = 0; i < affixChars.length; ++i) {
            affixChars[kind == AffixKind.PREFIX ? i : affixChars.length - i - 1] = (char)input.ints[input.offset + i];
        }
        return new String(affixChars);
    }

    private AffixCondition condition(int affixId) {
        int condition = this.dictionary.getAffixCondition(affixId);
        return condition == 0 ? AffixCondition.ALWAYS_TRUE : this.dictionary.patterns.get(condition);
    }

    private String strip(int affixId) {
        char stripOrd = this.dictionary.affixData(affixId, 1);
        int stripStart = this.dictionary.stripOffsets[stripOrd];
        int stripEnd = this.dictionary.stripOffsets[stripOrd + '\u0001'];
        return new String(this.dictionary.stripData, stripStart, stripEnd - stripStart);
    }

    public List<AffixedWord> getAllWordForms(String root2, Runnable checkCanceled) {
        ArrayList<AffixedWord> result = new ArrayList<AffixedWord>();
        DictEntries entries = this.dictionary.lookupEntries(root2);
        if (entries != null) {
            for (DictEntry entry : entries) {
                result.addAll(this.getAllWordForms(root2, entry.getFlags(), checkCanceled));
            }
        }
        return result;
    }

    public List<AffixedWord> getAllWordForms(String stem, String flags, Runnable checkCanceled) {
        char[] encodedFlags = this.dictionary.flagParsingStrategy.parseUtfFlags(flags);
        if (!this.shouldConsiderAtAll(encodedFlags)) {
            return List.of();
        }
        return this.getAllWordForms(DictEntry.create(stem, flags), encodedFlags, checkCanceled);
    }

    private List<AffixedWord> getAllWordForms(DictEntry entry, char[] encodedFlags, Runnable checkCanceled) {
        encodedFlags = WordFormGenerator.sortAndDeduplicate(encodedFlags);
        ArrayList<AffixedWord> result = new ArrayList<AffixedWord>();
        AffixedWord bare = new AffixedWord(entry.getStem(), entry, List.of(), List.of());
        checkCanceled.run();
        if (!FlagEnumerator.hasFlagInSortedArray(this.dictionary.needaffix, encodedFlags, 0, encodedFlags.length)) {
            result.add(bare);
        }
        result.addAll(this.expand(bare, encodedFlags, checkCanceled));
        return result;
    }

    private static char[] sortAndDeduplicate(char[] flags) {
        Arrays.sort(flags);
        for (int i = 1; i < flags.length; ++i) {
            if (flags[i] != flags[i - 1]) continue;
            return WordFormGenerator.deduplicate(flags);
        }
        return flags;
    }

    private static char[] deduplicate(char[] flags) {
        HashSet<Character> set = new HashSet<Character>();
        for (char flag : flags) {
            set.add(Character.valueOf(flag));
        }
        return Dictionary.toSortedCharArray(set);
    }

    protected boolean canStemToOriginal(AffixedWord derived) {
        String word = derived.getWord();
        char[] chars = word.toCharArray();
        if (this.isForbiddenWord(chars, 0, chars.length)) {
            return false;
        }
        final String stem = derived.getDictEntry().getStem();
        var processor = new Stemmer.StemCandidateProcessor(WordContext.SIMPLE_WORD){
            boolean foundStem;
            boolean foundForbidden;
            {
                super(context2);
                this.foundStem = false;
                this.foundForbidden = false;
            }

            @Override
            boolean processStemCandidate(char[] chars, int offset, int length, int lastAffix, int outerPrefix, int innerPrefix, int outerSuffix, int innerSuffix) {
                if (WordFormGenerator.this.isForbiddenWord(chars, offset, length)) {
                    this.foundForbidden = true;
                    return false;
                }
                this.foundStem |= length == stem.length() && stem.equals(new String(chars, offset, length));
                return !this.foundStem;
            }
        };
        this.stemmer.removeAffixes(chars, 0, chars.length, true, -1, -1, -1, processor);
        return processor.foundStem && !processor.foundForbidden;
    }

    private boolean isForbiddenWord(char[] chars, int offset, int length) {
        IntsRef forms;
        if (this.dictionary.forbiddenword != '\u0000' && (forms = this.dictionary.lookupWord(chars, offset, length)) != null) {
            for (int i = 0; i < forms.length; i += this.dictionary.formStep()) {
                if (!this.dictionary.hasFlag(forms.ints[forms.offset + i], this.dictionary.forbiddenword)) continue;
                return true;
            }
        }
        return false;
    }

    private List<AffixedWord> expand(AffixedWord stem, char[] flags, Runnable checkCanceled) {
        ArrayList<AffixedWord> result = new ArrayList<AffixedWord>();
        for (char flag : flags) {
            AffixKind kind;
            List<AffixEntry> entries = this.affixes.get(Character.valueOf(flag));
            if (entries == null || !this.isCompatibleWithPreviousAffixes(stem, kind = entries.get((int)0).kind, flag)) continue;
            for (AffixEntry affix : entries) {
                char[] append;
                checkCanceled.run();
                AffixedWord derived = affix.apply(stem, this.dictionary);
                if (derived == null || !this.shouldConsiderAtAll(append = this.appendFlags(affix))) continue;
                if (this.canStemToOriginal(derived)) {
                    result.add(derived);
                }
                if (!this.dictionary.isCrossProduct(affix.id)) continue;
                result.addAll(this.expand(derived, this.updateFlags(flags, flag, append), checkCanceled));
            }
        }
        return result;
    }

    private boolean shouldConsiderAtAll(char[] flags) {
        for (char flag : flags) {
            if (flag != this.dictionary.compoundBegin && flag != this.dictionary.compoundMiddle && flag != this.dictionary.compoundEnd && flag != this.dictionary.forbiddenword && flag != this.dictionary.onlyincompound) continue;
            return false;
        }
        return true;
    }

    private char[] updateFlags(char[] flags, char toRemove, char[] toAppend) {
        char[] result = new char[flags.length + toAppend.length - 1];
        int index = 0;
        for (char flag : flags) {
            if (flag == toRemove || flag == this.dictionary.needaffix) continue;
            result[index++] = flag;
        }
        for (char flag : toAppend) {
            result[index++] = flag;
        }
        return WordFormGenerator.sortAndDeduplicate(result);
    }

    private char[] appendFlags(AffixEntry affix) {
        char appendId = this.dictionary.affixData(affix.id, 3);
        return appendId == '\u0000' ? new char[]{} : this.dictionary.flagLookup.getFlags(appendId);
    }

    public void generateAllSimpleWords(Consumer<AffixedWord> consumer, Runnable checkCanceled) {
        this.dictionary.words.processAllWords(1, Integer.MAX_VALUE, false, (root2, lazyForms) -> {
            String rootStr = root2.toString();
            IntsRef forms = (IntsRef)lazyForms.get();
            for (int i = 0; i < forms.length; i += this.dictionary.formStep()) {
                char[] encodedFlags = this.dictionary.flagLookup.getFlags(forms.ints[forms.offset + i]);
                if (!this.shouldConsiderAtAll(encodedFlags)) continue;
                String presentableFlags = this.dictionary.flagParsingStrategy.printFlags(encodedFlags);
                DictEntry entry = DictEntry.create(rootStr, presentableFlags);
                for (AffixedWord aw : this.getAllWordForms(entry, encodedFlags, checkCanceled)) {
                    consumer.accept(aw);
                }
            }
        });
    }

    public EntrySuggestion compress(List<String> words, Set<String> forbidden, Runnable checkCanceled) {
        if (words.isEmpty()) {
            return null;
        }
        if (words.stream().anyMatch(forbidden::contains)) {
            throw new IllegalArgumentException("'words' and 'forbidden' shouldn't intersect");
        }
        return new WordCompressor(words, forbidden, checkCanceled).compress();
    }

    private boolean isCompatibleWithPreviousAffixes(AffixedWord stem, AffixKind kind, char flag) {
        boolean isPrefix = kind == AffixKind.PREFIX;
        List<AffixedWord.Affix> sameAffixes = isPrefix ? stem.getPrefixes() : stem.getSuffixes();
        int size = sameAffixes.size();
        if (size == 2) {
            return false;
        }
        if (isPrefix && size == 1 && !this.dictionary.complexPrefixes) {
            return false;
        }
        if (!isPrefix && !stem.getPrefixes().isEmpty()) {
            return false;
        }
        return size != 1 || this.dictionary.isFlagAppendedByAffix(sameAffixes.get((int)0).affixId, flag);
    }

    private static class State {
        final Map<String, Set<FlagSet>> stemToFlags;
        final int underGenerated;
        final int overGenerated;
        final int forbidden;

        State(Map<String, Set<FlagSet>> stemToFlags, int underGenerated, int overGenerated, int forbidden) {
            this.stemToFlags = stemToFlags;
            this.underGenerated = underGenerated;
            this.overGenerated = overGenerated;
            this.forbidden = forbidden;
        }
    }

    private static class FlagSet {
        final Set<Character> flags;
        final Dictionary dictionary;

        FlagSet(Set<Character> flags, Dictionary dictionary) {
            this.flags = flags;
            this.dictionary = dictionary;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FlagSet)) {
                return false;
            }
            FlagSet flagSet = (FlagSet)o;
            return this.flags.equals(flagSet.flags) && this.dictionary.equals(flagSet.dictionary);
        }

        public int hashCode() {
            return Objects.hash(this.flags, this.dictionary);
        }

        static Set<Character> flatten(Set<FlagSet> flagSets) {
            return flagSets.stream().flatMap(f -> f.flags.stream()).collect(Collectors.toSet());
        }

        public String toString() {
            return this.dictionary.flagParsingStrategy.printFlags(Dictionary.toSortedCharArray(this.flags));
        }
    }

    private class WordCompressor {
        private final Comparator<State> solutionFitness = Comparator.comparingInt(s2 -> s2.forbidden).thenComparingInt(s2 -> s2.underGenerated).thenComparingInt(s2 -> s2.stemToFlags.size()).thenComparingInt(s2 -> s2.overGenerated);
        private final Set<String> forbidden;
        private final Runnable checkCanceled;
        private final Set<String> wordSet;
        private final Set<String> existingStems;
        private final Map<String, Set<FlagSet>> stemToPossibleFlags = new HashMap<String, Set<FlagSet>>();
        private final Map<String, Integer> stemCounts = new LinkedHashMap<String, Integer>();
        private final Map<StemWithFlags, List<String>> expansionCache = new HashMap<StemWithFlags, List<String>>();

        WordCompressor(List<String> words, Set<String> forbidden, Runnable checkCanceled) {
            this.forbidden = forbidden;
            this.checkCanceled = checkCanceled;
            this.wordSet = new HashSet<String>(words);
            Stemmer.StemCandidateProcessor processor = new Stemmer.StemCandidateProcessor(WordContext.SIMPLE_WORD){

                @Override
                boolean processStemCandidate(char[] word, int offset, int length, int lastAffix, int outerPrefix, int innerPrefix, int outerSuffix, int innerSuffix) {
                    String candidate = new String(word, offset, length);
                    WordCompressor.this.stemCounts.merge(candidate, 1, Integer::sum);
                    LinkedHashSet<Character> flags = new LinkedHashSet<Character>();
                    if (outerPrefix >= 0) {
                        flags.add(Character.valueOf(WordFormGenerator.this.dictionary.affixData(outerPrefix, 0)));
                    }
                    if (innerPrefix >= 0) {
                        flags.add(Character.valueOf(WordFormGenerator.this.dictionary.affixData(innerPrefix, 0)));
                    }
                    if (outerSuffix >= 0) {
                        flags.add(Character.valueOf(WordFormGenerator.this.dictionary.affixData(outerSuffix, 0)));
                    }
                    if (innerSuffix >= 0) {
                        flags.add(Character.valueOf(WordFormGenerator.this.dictionary.affixData(innerSuffix, 0)));
                    }
                    WordCompressor.this.stemToPossibleFlags.computeIfAbsent(candidate, __ -> new LinkedHashSet()).add(new FlagSet(flags, WordFormGenerator.this.dictionary));
                    return true;
                }
            };
            for (String word : words) {
                checkCanceled.run();
                this.stemCounts.merge(word, 1, Integer::sum);
                this.stemToPossibleFlags.computeIfAbsent(word, __ -> new LinkedHashSet());
                WordFormGenerator.this.stemmer.removeAffixes(word.toCharArray(), 0, word.length(), true, -1, -1, -1, processor);
            }
            this.existingStems = this.stemCounts.keySet().stream().filter(stem -> WordFormGenerator.this.dictionary.lookupEntries((String)stem) != null).collect(Collectors.toSet());
        }

        EntrySuggestion compress() {
            Comparator<String> stemSorter = Comparator.comparing(s2 -> this.existingStems.contains(s2)).thenComparing(this.stemCounts::get).reversed();
            List sortedStems = this.stemCounts.keySet().stream().sorted(stemSorter).collect(Collectors.toList());
            PriorityQueue<State> queue = new PriorityQueue<State>(this.solutionFitness);
            queue.offer(new State(Map.of(), this.wordSet.size(), 0, 0));
            State result = null;
            while (!queue.isEmpty()) {
                State state = queue.poll();
                if (state.underGenerated == 0) {
                    if (result == null || this.solutionFitness.compare(state, result) < 0) {
                        result = state;
                    }
                    if (state.forbidden != 0) continue;
                    break;
                }
                for (String string : sortedStems) {
                    if (state.stemToFlags.containsKey(string)) continue;
                    queue.offer(this.addStem(state, string));
                }
                for (Map.Entry entry : state.stemToFlags.entrySet()) {
                    for (FlagSet flags : this.stemToPossibleFlags.get(entry.getKey())) {
                        if (((Set)entry.getValue()).contains(flags)) continue;
                        queue.offer(this.addFlags(state, (String)entry.getKey(), flags));
                    }
                }
            }
            return result == null ? null : this.toSuggestion(result);
        }

        EntrySuggestion toSuggestion(State state) {
            ArrayList<DictEntry> toEdit = new ArrayList<DictEntry>();
            ArrayList<DictEntry> toAdd = new ArrayList<DictEntry>();
            for (Map.Entry<String, Set<FlagSet>> entry : state.stemToFlags.entrySet()) {
                this.addEntry(toEdit, toAdd, entry.getKey(), FlagSet.flatten(entry.getValue()));
            }
            ArrayList<String> extraGenerated = new ArrayList<String>();
            for (String extra : this.allGenerated(state.stemToFlags).distinct().sorted().collect(Collectors.toList())) {
                if (this.wordSet.contains(extra)) continue;
                if (this.forbidden.contains(extra) && WordFormGenerator.this.dictionary.forbiddenword != '\u0000') {
                    this.addEntry(toEdit, toAdd, extra, Set.of(Character.valueOf(WordFormGenerator.this.dictionary.forbiddenword)));
                    continue;
                }
                extraGenerated.add(extra);
            }
            return new EntrySuggestion(toEdit, toAdd, extraGenerated);
        }

        private void addEntry(List<DictEntry> toEdit, List<DictEntry> toAdd, String stem, Set<Character> flags) {
            String flagString = this.toFlagString(flags);
            (this.existingStems.contains(stem) ? toEdit : toAdd).add(DictEntry.create(stem, flagString));
        }

        private State addStem(State state, String stem) {
            LinkedHashMap<String, Set<FlagSet>> stemToFlags = new LinkedHashMap<String, Set<FlagSet>>(state.stemToFlags);
            stemToFlags.put(stem, Set.of());
            return this.newState(stemToFlags);
        }

        private State addFlags(State state, String stem, FlagSet flags) {
            LinkedHashMap<String, Set<FlagSet>> stemToFlags = new LinkedHashMap<String, Set<FlagSet>>(state.stemToFlags);
            LinkedHashSet<FlagSet> flagSets = new LinkedHashSet<FlagSet>((Collection)stemToFlags.get(stem));
            flagSets.add(flags);
            stemToFlags.put(stem, flagSets);
            return this.newState(stemToFlags);
        }

        private State newState(Map<String, Set<FlagSet>> stemToFlags) {
            Set allGenerated = this.allGenerated(stemToFlags).collect(Collectors.toSet());
            return new State(stemToFlags, (int)this.wordSet.stream().filter(s2 -> !allGenerated.contains(s2)).count(), (int)allGenerated.stream().filter(s2 -> !this.wordSet.contains(s2)).count(), (int)allGenerated.stream().filter(s2 -> this.forbidden.contains(s2)).count());
        }

        private Stream<String> allGenerated(Map<String, Set<FlagSet>> stemToFlags) {
            Function<StemWithFlags, List> expandToWords = e2 -> this.expand(e2.stem, FlagSet.flatten(e2.flags)).stream().map(w -> w.getWord()).collect(Collectors.toList());
            return stemToFlags.entrySet().stream().map(e2 -> new StemWithFlags((String)e2.getKey(), (Set)e2.getValue())).flatMap(swc -> this.expansionCache.computeIfAbsent((StemWithFlags)swc, (Function<StemWithFlags, List<String>>)expandToWords).stream());
        }

        private List<AffixedWord> expand(String stem, Set<Character> flagSet) {
            return WordFormGenerator.this.getAllWordForms(stem, this.toFlagString(flagSet), this.checkCanceled);
        }

        private String toFlagString(Set<Character> flagSet) {
            return WordFormGenerator.this.dictionary.flagParsingStrategy.printFlags(Dictionary.toSortedCharArray(flagSet));
        }

        private class StemWithFlags {
            final String stem;
            final Set<FlagSet> flags;

            StemWithFlags(String stem, Set<FlagSet> flags) {
                this.stem = stem;
                this.flags = flags;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof StemWithFlags)) {
                    return false;
                }
                StemWithFlags that = (StemWithFlags)o;
                return this.stem.equals(that.stem) && this.flags.equals(that.flags);
            }

            public int hashCode() {
                return Objects.hash(this.stem, this.flags);
            }
        }
    }

    private static class AffixEntry {
        final int id;
        final char flag;
        final AffixKind kind;
        final String affix;
        final String strip;
        final AffixCondition condition;

        AffixEntry(int id, char flag, AffixKind kind, String affix, String strip, AffixCondition condition) {
            this.id = id;
            this.flag = flag;
            this.kind = kind;
            this.affix = affix;
            this.strip = strip;
            this.condition = condition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AffixEntry)) {
                return false;
            }
            AffixEntry that = (AffixEntry)o;
            return this.id == that.id && this.flag == that.flag && this.kind == that.kind && this.affix.equals(that.affix) && this.strip.equals(that.strip) && this.condition.equals(that.condition);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, Character.valueOf(this.flag), this.kind, this.affix, this.strip, this.condition});
        }

        AffixedWord apply(AffixedWord stem, Dictionary dictionary) {
            String stripped;
            boolean isPrefix;
            String word = stem.getWord();
            boolean bl = isPrefix = this.kind == AffixKind.PREFIX;
            if (!(!isPrefix ? word.endsWith(this.strip) : word.startsWith(this.strip))) {
                return null;
            }
            String string = stripped = isPrefix ? word.substring(this.strip.length()) : word.substring(0, word.length() - this.strip.length());
            if (!this.condition.acceptsStem(stripped)) {
                return null;
            }
            String applied = isPrefix ? this.affix + stripped : stripped + this.affix;
            List<AffixedWord.Affix> prefixes = isPrefix ? new ArrayList<AffixedWord.Affix>(stem.getPrefixes()) : stem.getPrefixes();
            ArrayList<AffixedWord.Affix> suffixes = isPrefix ? stem.getSuffixes() : new ArrayList<AffixedWord.Affix>(stem.getSuffixes());
            (isPrefix ? prefixes : suffixes).add(0, new AffixedWord.Affix(dictionary, this.id));
            return new AffixedWord(applied, stem.getDictEntry(), prefixes, suffixes);
        }
    }
}

