/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.index.RangeIndex;
import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.storage.system.DatasetGraphStorage;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.lib.NodeLib;
import org.apache.jena.tdb2.params.StoreParams;
import org.apache.jena.tdb2.store.GraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.NodeIdFactory;
import org.apache.jena.tdb2.store.QuadTable;
import org.apache.jena.tdb2.store.StorageTDB;
import org.apache.jena.tdb2.store.TripleTable;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;
import org.apache.jena.tdb2.store.tupletable.TupleIndexRecord;

public final class DatasetGraphTDB
extends DatasetGraphStorage {
    private final StorageTDB storageTDB;
    private final Location location;
    private final TransactionalSystem txnSystem;
    private final StoreParams storeParams;
    private final ReorderTransformation reorderTransformation;
    private boolean isClosed = false;

    public DatasetGraphTDB(Location location, StoreParams params, ReorderTransformation reorderTransformation, StorageTDB storage, StoragePrefixes prefixes, TransactionalSystem txnSystem) {
        super(storage, prefixes, txnSystem);
        this.storageTDB = storage;
        this.location = location;
        this.storeParams = params;
        this.txnSystem = txnSystem;
        this.reorderTransformation = reorderTransformation;
    }

    private void checkNotClosed() {
        if (this.isClosed) {
            throw new TDBException("dataset closed");
        }
    }

    @Override
    public boolean supportsTransactionAbort() {
        return true;
    }

    public Location getLocation() {
        return this.location;
    }

    public QuadTable getQuadTable() {
        this.checkNotClosed();
        return this.storageTDB.getQuadTable();
    }

    public TripleTable getTripleTable() {
        this.checkNotClosed();
        return this.storageTDB.getTripleTable();
    }

    public TransactionalSystem getTxnSystem() {
        return this.txnSystem;
    }

    public StoreParams getStoreParams() {
        return this.storeParams;
    }

    public ReorderTransformation getReorderTransform() {
        return this.reorderTransformation;
    }

    @Override
    public void close() {
        this.isClosed = true;
        super.close();
    }

    public void shutdown() {
        this.close();
        this.txnSystem.getTxnMgr().shutdown();
    }

    @Override
    public Graph getDefaultGraph() {
        return this.getDefaultGraphTDB();
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return this.getGraphTDB(graphNode);
    }

    @Override
    public Graph getUnionGraph() {
        return this.getUnionGraphTDB();
    }

    public GraphTDB getDefaultGraphTDB() {
        this.checkNotClosed();
        return GraphTDB.tdb_createDefaultGraph(this, this.getStoragePrefixes());
    }

    public GraphTDB getGraphTDB(Node graphNode) {
        this.checkNotClosed();
        return GraphTDB.tdb_createNamedGraph(this, graphNode, this.getStoragePrefixes());
    }

    public GraphTDB getUnionGraphTDB() {
        this.checkNotClosed();
        return GraphTDB.tdb_createUnionGraph(this, this.getStoragePrefixes());
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        RangeIndex rangeIndex;
        this.checkNotClosed();
        NodeTupleTable quads = this.getQuadTable().getNodeTupleTable();
        TupleIndexRecord graphIndex = quads.getTupleTable().selectIndex("G", TupleIndexRecord.class);
        if (graphIndex != null && (rangeIndex = graphIndex.getRangeIndex()) instanceof BPlusTree) {
            BPlusTree bpt = (BPlusTree)rangeIndex;
            Iter<NodeId> distinctGraphNodeIds = Iter.iter(bpt.distinctByKeyPrefix(8)).map(r -> NodeIdFactory.get(r.getKey(), 0));
            return NodeLib.nodes(quads.getNodeTable(), distinctGraphNodeIds);
        }
        Iterator<Tuple<NodeId>> x = quads.findAll();
        boolean usingGraphBasedIndex = StringUtils.startsWith(quads.getTupleTable().getIndex(0).getName(), "G");
        Iter<NodeId> graphNodeIds = Iter.iter(x).map(t2 -> (NodeId)t2.get(0));
        Iterator<NodeId> distinctGraphNodeIds = usingGraphBasedIndex ? Iter.distinctAdjacent(graphNodeIds) : Iter.distinct(graphNodeIds);
        Iterator<Node> r2 = NodeLib.nodes(quads.getNodeTable(), distinctGraphNodeIds);
        return r2;
    }

    public NodeTupleTable chooseNodeTupleTable(Node graphNode) {
        this.checkNotClosed();
        if (graphNode == null || Quad.isDefaultGraph(graphNode)) {
            return this.getTripleTable().getNodeTupleTable();
        }
        return this.getQuadTable().getNodeTupleTable();
    }
}

