/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.util.graph.Findable;

public class FindableCollection
implements Findable {
    private Collection<Triple> triples;

    public FindableCollection(Collection<Triple> triples) {
        this.triples = triples;
    }

    @Override
    public Iterator<Triple> find(Node s2, Node p, Node o) {
        Node _s = FindableCollection.anyAsNull(s2);
        Node _p = FindableCollection.anyAsNull(p);
        Node _o = FindableCollection.anyAsNull(o);
        return Iter.filter(this.triples.iterator(), t2 -> FindableCollection.matches(t2, _s, _p, _o));
    }

    private static Node anyAsNull(Node n) {
        return n == Node.ANY ? null : n;
    }

    static boolean matches(Triple t2, Node s2, Node p, Node o) {
        if (s2 != null && !Objects.equals(s2, t2.getSubject())) {
            return false;
        }
        if (p != null && !Objects.equals(p, t2.getPredicate())) {
            return false;
        }
        return o == null || Objects.equals(o, t2.getObject());
    }

    @Override
    public boolean contains(Node s2, Node p, Node o) {
        Node _s = FindableCollection.anyAsNull(s2);
        Node _p = FindableCollection.anyAsNull(p);
        Node _o = FindableCollection.anyAsNull(o);
        for (Triple t2 : this.triples) {
            if (!FindableCollection.matches(t2, _s, _p, _o)) continue;
            return true;
        }
        return false;
    }
}

