/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax;

import java.util.Collection;
import java.util.Iterator;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementExists;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementNotExists;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.util.VarUtils;

public class PatternVarsVisitor
extends ElementVisitorBase {
    public Collection<Var> acc;

    public PatternVarsVisitor(Collection<Var> s2) {
        this.acc = s2;
    }

    @Override
    public void visit(ElementTriplesBlock el) {
        Iterator<Triple> iter = el.patternElts();
        while (iter.hasNext()) {
            Triple t2 = iter.next();
            VarUtils.addVarsFromTriple(this.acc, t2);
        }
    }

    @Override
    public void visit(ElementPathBlock el) {
        Iterator<TriplePath> iter = el.patternElts();
        while (iter.hasNext()) {
            TriplePath tp = iter.next();
            if (tp.isTriple()) {
                VarUtils.addVarsFromTriple(this.acc, tp.asTriple());
                continue;
            }
            VarUtils.addVarsFromTriplePath(this.acc, tp);
        }
    }

    @Override
    public void visit(ElementExists el) {
    }

    @Override
    public void visit(ElementNotExists el) {
    }

    @Override
    public void visit(ElementMinus el) {
    }

    @Override
    public void visit(ElementFilter el) {
    }

    @Override
    public void visit(ElementNamedGraph el) {
        VarUtils.addVar(this.acc, el.getGraphNameNode());
    }

    @Override
    public void visit(ElementSubQuery el) {
        el.getQuery().setResultVars();
        VarExprList x = el.getQuery().getProject();
        this.acc.addAll(x.getVars());
    }

    @Override
    public void visit(ElementAssign el) {
        this.acc.add(el.getVar());
    }

    @Override
    public void visit(ElementBind el) {
        this.acc.add(el.getVar());
    }

    @Override
    public void visit(ElementData el) {
        this.acc.addAll(el.getVars());
    }
}

