/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphTxn
extends GraphWrapper
implements Transactional {
    private DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
    private Graph graph = this.dsg.getDefaultGraph();
    private static boolean ISOLATE = false;

    public GraphTxn() {
        super(null);
    }

    @Override
    public Graph get() {
        return this.graph;
    }

    private Transactional getT() {
        return this.dsg;
    }

    @Override
    public void begin(TxnType type) {
        this.getT().begin(type);
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.getT().begin(readWrite);
    }

    @Override
    public boolean promote(Transactional.Promote mode) {
        return this.getT().promote(mode);
    }

    @Override
    public void commit() {
        this.getT().commit();
    }

    @Override
    public void abort() {
        this.getT().abort();
    }

    @Override
    public void end() {
        this.getT().end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.getT().transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.getT().transactionType();
    }

    @Override
    public boolean isInTransaction() {
        return this.getT().isInTransaction();
    }

    @Override
    public ExtendedIterator<Triple> find(Triple triple) {
        if (ISOLATE) {
            return this.isolate(this.get().find(triple));
        }
        return new IteratorTxn<Triple>(this, this.get().find(triple));
    }

    @Override
    public ExtendedIterator<Triple> find(Node s2, Node p, Node o) {
        if (ISOLATE) {
            return this.isolate(this.get().find(s2, p, o));
        }
        return new IteratorTxn<Triple>(this, this.get().find(s2, p, o));
    }

    private ExtendedIterator<Triple> isolate(ExtendedIterator<Triple> iter) {
        List<Triple> list = iter.toList();
        return WrappedIterator.create(list.iterator());
    }

    private static class IteratorTxn<T>
    extends WrappedIterator<T> {
        private final GraphTxn graph;
        private final boolean needIterTxn;
        private boolean isClosed = false;

        IteratorTxn(GraphTxn graph, ExtendedIterator<T> base) {
            super(base, true);
            this.graph = graph;
            boolean bl = this.needIterTxn = !graph.getT().isInTransaction();
            if (this.needIterTxn) {
                graph.begin(TxnType.READ);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            try {
                while (this.hasNext()) {
                    action.accept(this.next());
                }
            }
            finally {
                this.close();
            }
        }

        @Override
        public void forEach(Consumer<T> action) {
            try {
                while (this.hasNext()) {
                    action.accept(this.next());
                }
            }
            finally {
                this.close();
            }
        }

        @Override
        public boolean hasNext() {
            boolean b = super.hasNext();
            if (!b) {
                this.close();
            }
            return b;
        }

        @Override
        public void close() {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (this.needIterTxn) {
                this.graph.commit();
                this.graph.end();
            }
        }
    }
}

