/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.util.List;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.core.Var;

public class TransformOrderByDistinctApplication
extends TransformCopy {
    @Override
    public Op transform(OpDistinct opDistinct, Op subOp) {
        if (subOp instanceof OpProject) {
            OpProject project = (OpProject)subOp;
            if (project.getSubOp() instanceof OpOrder) {
                List<Var> projectVars = project.getVars();
                OpOrder order = (OpOrder)project.getSubOp();
                boolean ok = true;
                for (SortCondition condition : order.getConditions()) {
                    if (this.isValidSortCondition(condition, projectVars)) continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    OpProject newProject = new OpProject(order.getSubOp(), project.getVars());
                    OpDistinct newDistinct = new OpDistinct(newProject);
                    return new OpOrder(newDistinct, order.getConditions());
                }
            }
        } else if (subOp instanceof OpOrder) {
            OpOrder order = (OpOrder)subOp;
            OpDistinct newDistinct = new OpDistinct(order.getSubOp());
            return new OpOrder(newDistinct, order.getConditions());
        }
        return super.transform(opDistinct, subOp);
    }

    @Override
    public Op transform(OpReduced opReduced, Op subOp) {
        OpProject project;
        if (subOp instanceof OpProject && (project = (OpProject)subOp).getSubOp() instanceof OpOrder) {
            List<Var> projectVars = project.getVars();
            OpOrder order = (OpOrder)project.getSubOp();
            boolean ok = true;
            for (SortCondition condition : order.getConditions()) {
                if (this.isValidSortCondition(condition, projectVars)) continue;
                ok = false;
                break;
            }
            if (ok) {
                OpProject newProject = new OpProject(order.getSubOp(), project.getVars());
                Op newReduced = OpReduced.create(newProject);
                return new OpOrder(newReduced, order.getConditions());
            }
        }
        return super.transform(opReduced, subOp);
    }

    private boolean isValidSortCondition(SortCondition cond, List<Var> projectVars) {
        if (cond.getExpression().isVariable()) {
            return projectVars.contains(cond.getExpression().asVar());
        }
        for (Var v : cond.getExpression().getVarsMentioned()) {
            if (projectVars.contains(v)) continue;
            return false;
        }
        return true;
    }
}

