/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.table.TableUnit;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpJoin
extends Op2 {
    public static Op create(Op left, Op right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return new OpJoin(left, right);
    }

    public static Op createReduce(Op left, Op right) {
        if (left == null || OpJoin.isJoinIdentify(left)) {
            return right;
        }
        if (right == null || OpJoin.isJoinIdentify(right)) {
            return left;
        }
        return new OpJoin(left, right);
    }

    public static boolean isJoinIdentify(Op op) {
        if (!(op instanceof OpTable)) {
            return false;
        }
        Table t2 = ((OpTable)op).getTable();
        return TableUnit.isTableUnit(t2);
    }

    private OpJoin(Op left, Op right) {
        super(left, right);
    }

    @Override
    public String getName() {
        return "join";
    }

    @Override
    public Op apply(Transform transform, Op left, Op right) {
        return transform.transform(this, left, right);
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op2 copy(Op newLeft, Op newRight) {
        return new OpJoin(newLeft, newRight);
    }

    @Override
    public boolean equalTo(Op op2, NodeIsomorphismMap labelMap) {
        if (!(op2 instanceof OpJoin)) {
            return false;
        }
        return super.sameArgumentsAs((Op2)op2, labelMap);
    }
}

